/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _cookie_h_
#define _cookie_h_

#include <time.h>

#include "url.h"

typedef struct _cookie_entry {
	struct _cookie_entry 	*next;
	struct _cookie_entry	*prev;
	char			*domain;
	char			*path;
	time_t			expires;
	bool_t			secure;
	bool_t			flag;
	char			*name;
	char			*value;
	bool_t			loaded;
} cookie_entry;

extern cookie_entry *cookie_read_ns(char *);
extern int cookie_write_ns(char *);
extern int cookie_update_ns();
extern char *cookie_get_field(url *);
extern void cookie_insert_field(char *, url *);
extern void cookie_free_all(cookie_entry *);
extern cookie_entry *cookie_get_last_entry(cookie_entry *, int*);
#endif

