#
# spec file for package pavuk (Version 0.9.33)
#
# Copyright (c) 2004 SUSE LINUX AG, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#

# norootforbuild
# neededforbuild  glib glib-devel gtk gtk-devel update-desktop-files x-devel-packages

BuildRequires: aaa_base acl attr bash bind-utils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv less libacl libattr libgcc libnscd libselinux libstdc++ libxcrypt libzio m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils rcs readline sed strace syslogd sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils expat fontconfig fontconfig-devel gcc gdbm gettext glib glib-devel gnome-filesystem gtk gtk-devel libtool perl rpm update-desktop-files xorg-x11-devel xorg-x11-libs

Name:         pavuk
Version:      0.9.33
Release:      1
Autoreqprov:  on
Group:        Productivity/Networking/Web/Utilities
License:      GPL
URL:          http://pavuk.sourceforge.net/
Summary:      Powerful WWW or FTP site mirror tool
Summary(de):  Mchtiges Programm zum Spiegeln von Websites
Source:       %{name}-%{version}.tar.bz2
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
Pavuk is used to download or mirror web sites or files. It transfers documents
from HTTP, FTP, Gopher and optionally from HTTPS (HTTP over SSL) servers. An
optional GTK GUI allows easy configuration. Many options allow fine-tuning for
the usage scenario. This is an tool for experts and much to complicated for
beginners.

%description -l de
Pavuk wird genutzt, um Webseiten oder Dateien herunterzuladen oder zu spiegeln.
Es kann Doukente von HTTP-, FTP-, Gopher- und optional HTTPS-Servern (HTTP
ber SSL) laden. Eine optionale GTK-Oberflche erlaubt einfaches konfigurieren.
Viele Optionen ermglichen eine Feinanpassung an die Aufgabenstellung. Dieses
Programm ist fr Anfnger sehr kompliziert und fr Experten gedacht.

%prep
%setup -q

%build
%{suse_update_config -f . }
CXXFLAGS="$RPM_OPT_FLAGS -DNDEBUG -Wall"
	./configure \
        --disable-gnome \
 --disable-gtk2 \
        --enable-utf-8 \
        --prefix=%{_prefix} \
        --sysconfdir=%{_sysconfdir} \
        --mandir=%{_mandir}
make %{?jobs:-j%jobs}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
rm $RPM_BUILD_ROOT%{_bindir}/*.sh
%find_lang %name
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps
cp $RPM_BUILD_ROOT%{_datadir}/icons/pavuk_32x32.xpm \
   $RPM_BUILD_ROOT%{_datadir}/pixmaps/pavuk.xpm
iconv %{name}.desktop -f iso-8859-1 -t utf-8 >%{name}.desktop.utf8
mv %{name}.desktop.utf8 %{name}.desktop
%suse_update_desktop_file -i %name Network FileTransfer

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %name.lang
%defattr(-,root,root)
%doc FAQ README COPYING TODO wget-pavuk.HOWTO jsbind.txt
%doc ABOUT-NLS BUGS AUTHORS NEWS ChangeLog MAILINGLIST CREDITS
%doc %{_mandir}/man?/*
%doc pavukrc.sample
%{_bindir}/*
%{_datadir}/icons/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*.desktop

%changelog -n pavuk
* Tue Sep 27 2005 - soft@dstoecker.de
- updated to 0.9.33
* Mon Jan 10 2005 - soft@dstoecker.de
- update to 0.9.32
- german texts added
- lot of cleanup work
* Tue Jul 13 2004 - mjancar@suse.cz
- update to 0.9pl30b
- kill obsolete patches
- fix buffer overflow (#42141, #42764)
* Mon Jun 21 2004 - mjancar@suse.cz
- fix buffer overflow (#42141)
- enable the spelling error fix
* Sat Jan 10 2004 - adrian@suse.de
- build as user
* Mon Aug 25 2003 - mjancar@suse.cz
- fix spelling error in pavukrc (#27733)
* Fri Aug 15 2003 - adrian@suse.de
- add desktop file
* Fri Jul 11 2003 - meissner@suse.de
- run suse_update_config.
* Mon Jun 16 2003 - coolo@suse.de
- use BuildRoot
* Mon Mar 18 2002 - uli@suse.de
- build with --enable-debug to allow fine-tuning (bug #15105)
* Mon Mar 04 2002 - uli@suse.de
- commented out entries in pavukrc that require customization
  (bug #13977)
* Wed Aug 15 2001 - uli@suse.de
- update -> 0.9pl28
* Tue Jul 24 2001 - uli@suse.de
- update -> 0.9pl27
* Wed May 09 2001 - mfabian@suse.de
- bzip2 sources
* Wed Apr 18 2001 - uli@suse.de
- more 64 bit fixes
* Thu Mar 29 2001 - uli@suse.de
- fixed for gcc >2.95
- 64 bit fixes
* Mon Nov 06 2000 - ro@suse.de
- fixed neededforbuild
* Wed Jun 07 2000 - ro@suse.de
- doc relocation
* Sun Mar 05 2000 - olh@suse.de
- New version 0.9pl23, move manpages
* Fri Jan 14 2000 - uli@suse.de
- New version 0.9pl23
* Tue Oct 26 1999 - uli@suse.de
- New version 0.9pl21
* Fri Sep 17 1999 - kettner@suse.de
- Reinserted old # Commandline: line.
* Mon Sep 13 1999 - bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Tue Jul 13 1999 - bs@suse.de
- use gtk and glib instead of gtkn and glibn
* Thu Jul 08 1999 - uli@suse.de
- Spec file created from pavuk-0.9pl17.tgz by autospec
