/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     parameter.c                                                    *
 *            Callback functions to adjust parameters                        *
 * Author:    Andreas Tille                                                  *
 * Date:      14.06.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <gdk/gdkkeysyms.h>
#include <sys/param.h>
#include "paul.h"
#include "callback.h"
#include "names.h"

/*****************************************************************************************
 * Parameters for brightness                                                             *
 *****************************************************************************************/

void BrightnessParameterCallback(PAUL *p)
{
  GtkWidget *hbox, *vbox, *label, *browse;
  char      *bright;
   
  g_return_if_fail ( IS_PAUL(p) );
  bright = g_malloc0(MAXPATHLEN);
  if ( p->opt->bright ) {
    strcpy(bright, p->opt->bright);
    FREE(p->opt->bright);
  } else
    strcpy(bright, BRIGHTFILE);

  hbox  = gtk_hbox_new(FALSE, 2);
  vbox  = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(hbox), vbox);
  
  label = gtk_label_new(_("Use monochrome options to determine\nthe channel for brightness calculation"));
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  
  browse = FileEntryOrBrowse(NULL, bright);
  gtk_box_pack_start(GTK_BOX(vbox), browse, TRUE, TRUE, 0);

  gtk_widget_show_all(hbox);
  BuildParameterInput(hbox, Brightness, Brightness_p, bright, 
                      GTK_SIGNAL_FUNC(FileSelectChanged), &(p->opt->bright), NULL, NULL);
}

/*****************************************************************************************
 * Parameters for border deletion                                                        *
 *****************************************************************************************/

void DelBorderParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 2;

  g_return_if_fail ( IS_PAUL(p) );
  
  para               = g_new0(ITEM, np+1);
  para->name         = _("Maximum gray value for border:");
  para->typ          = P_UCHAR;                                
  para->val          = &(p->opt->thresh);                      
  para->upper        = 255.0;                                  
  para->lower        =   0.0;                                  
  para->valchg       = NULL;                                   
  para->adj          = NULL;                                   
  para->userdata     = NULL;                                   
  (para+1)->name     = _("Allowed error for one pixel:");
  (para+1)->typ      = P_UCHAR;                                
  (para+1)->val      = &(p->opt->terr);                        
  (para+1)->upper    = 255.0;                                  
  (para+1)->lower    =   0.0;                                  
  (para+1)->valchg   = NULL;
  (para+1)->adj      = NULL;
  (para+1)->userdata = NULL;

  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Remove_bo, Remove_bo_par, para,
                         GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}

/*****************************************************************************************
 * parameters for difference images                                                      *
 * remark: the scale parameters influence building differences too                       *
 *****************************************************************************************/

void DifferenceParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 1;
  
  g_return_if_fail ( IS_PAUL(p) );
  
  para           = g_new0(ITEM, np+1);
   
  para->name     = _("Level:");
  para->typ      = P_UCHAR;
  para->val      = &(p->opt->eps);
  para->upper    = 255.0;
  para->lower    =   0.0;
  para->valchg   = NULL;
  para->adj      = NULL;
  para->userdata = NULL;

  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Difference, Difference_p, para, 
                        GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}

/*****************************************************************************************
 * Parameters to change contrast or brightness of an image                               *
 * also influence difference images                                                      *
 *****************************************************************************************/

void ScaleParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 2;
   
  g_return_if_fail ( IS_PAUL(p) );
  
  para               = g_new0(ITEM, np+1);
  para->name         = _("Contrast factor:");
  para->typ          = P_DOUBLE;
  para->val          = &(p->opt->scale);
  para->upper        = 255.0;
  para->lower        = 0.0;
  para->valchg       = NULL;
  para->adj          = NULL;
  para->userdata     = NULL;
  
  (para+1)->name     = _("Brightness Offset:");
  (para+1)->typ      = P_INT;
  (para+1)->val      = &(p->opt->offset);
  (para+1)->upper    =  255.0;
  (para+1)->lower    = -255.0;
  (para+1)->valchg   = NULL;
  (para+1)->adj      = NULL;
  (para+1)->userdata = NULL;

  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Contrast, Contrast_par, para, 
                        GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}

/*****************************************************************************************
 * Parameters to make monochrome images (visualisation of paul in green)                 *
 *****************************************************************************************/

void GrayParameterCallback(PAUL *p)
{
  RADIO         *para;
  GtkWidget     *box;
  int            np = 4;
  unsigned char  radio_val;

  g_return_if_fail ( IS_PAUL(p) );
  
  radio_val = ( p->opt->greps > 3 ) ? 3 : p->opt->greps;

  para            = g_new0(RADIO, np+1);
  para->name      = _("Use red channel");
  para->val       = 0;
  (para+1)->name  = _("Use green channel");
  (para+1)->val   = 1;
  (para+2)->name  = _("Use blue channel");
  (para+2)->val   = 2;
  (para+3)->name  = _("Average of all channels");
  (para+3)->val   = 3;
 
  if ( (box = BuildRadioTable(para, np, radio_val)) ) 
    BuildParameterInput(box, Monochrome, Monochrome_p, para, 
                        GTK_SIGNAL_FUNC(_RadioParameterChanged), &(p->opt->greps), NULL, NULL);
}

/*****************************************************************************************
 * Parameters to filter images                                                           *
 *****************************************************************************************/

void FilterParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 1;
 
  g_return_if_fail ( IS_PAUL(p) );
   
  para           = g_new0(ITEM, np+1);
  para->name     = _("Filter size (has to be odd number):");
  para->typ      = P_UCHAR;
  para->val      = &(p->opt->fordn);
  para->upper    = 11.0;
  para->lower    =  3.0;
  para->valchg   = NULL;
  para->adj      = NULL;
  para->userdata = NULL;

  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Filter, Filter_par, para,
                        GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}

/*****************************************************************************************
 * parameters to shrink images                                                           *
 *****************************************************************************************/

void ShrinkParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 1;
  
  g_return_if_fail ( IS_PAUL(p) );
  
  para           = g_new0(ITEM, np+1);
   
  para->name     = _("Level:");
  para->typ      = P_UCHAR;
  para->val      = &(p->opt->shr);
  para->upper    = 255.0;
  para->lower    =   0.0;
  para->valchg   = NULL;
  para->adj      = NULL;
  para->userdata = NULL;

  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Shrink, Shrink_p, para, 
                        GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}

/*****************************************************************************************
 * rotation angle input                                                                  *
 *****************************************************************************************/

void RotationParameterCallback(PAUL *p)
{
  ITEM      *para;
  GtkWidget *table;
  int        np = 1;
   
  para           = g_new0(ITEM, np+1);
  para->name     = _("Rotation angle []:");
  para->typ      = P_DOUBLE;
  while ( p->opt->angle >  360.0 ) p->opt->angle -= 360.0;
  while ( p->opt->angle <    0.0 ) p->opt->angle += 360.0;
  para->val      = &(p->opt->angle);
  para->upper    = 360.0;
  para->lower    = 0.0;
  para->valchg   = NULL;
  para->adj      = NULL;
  para->userdata = NULL;
   
  if ( (table = BuildParameterTable(para, np)) )
    BuildParameterInput(table, Rotation_p, Rotation_d, para, 
                        GTK_SIGNAL_FUNC(_ParameterChanged), table, NULL, NULL);
}



