#!/usr/bin/perl -w

BEGIN { unshift @INC, "perl5/blib/lib" };

use parted;
use Data::Dumper;

print "This is a perl wrapper around libparted ", parted::get_version, "\n";

parted::device_probe_all ();

sub display_device($) {
  my ($dev) = @_;
  print Dumper($dev);
  printf "Device: %s - Model: %s\n", $dev->{path}, $dev->{model};
  my $disktype = $dev->disk_probe() or die "Can't get disktype from dev: $!";
  printf "DiskType: %s", $disktype->{name};

#  $disk->read() or die "$!";

  print "\n";
}

$dev = parted::device_get_first () or die "can't get a device: $!";
display_device($dev);

while ($dev = $dev->get_next()) {
  display_device($dev);
}
