/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998, 1999, 2000 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_CONSTRAINT_H_INCLUDED
#define PED_CONSTRAINT_H_INCLUDED

typedef struct _PedConstraint	PedConstraint;

#include <parted/device.h>
#include <parted/disk.h>
#include <parted/natmath.h>

struct _PedConstraint {
	PedAlignment*	start_align;
	PedAlignment*	end_align;
	PedGeometry*	start_range;
	PedGeometry*	end_range;
	PedSector	min_size;
};

extern int
ped_constraint_init (
	PedConstraint* constraint,
	const PedAlignment* start_align,
	const PedAlignment* end_align,
	const PedGeometry* start_range,
	const PedGeometry* end_range,
	PedSector min_size);
				
extern PedConstraint*
ped_constraint_new (
	const PedAlignment* start_align,
	const PedAlignment* end_align,
	const PedGeometry* start_range,
	const PedGeometry* end_range,
	PedSector min_size);

extern PedConstraint*
ped_constraint_duplicate (const PedConstraint* constraint);

extern void
ped_constraint_done (PedConstraint* constraint);

extern void
ped_constraint_destroy (PedConstraint* constraint);

extern PedConstraint*
ped_constraint_intersect (const PedConstraint* a, const PedConstraint* b);

extern PedGeometry*
ped_constraint_solve_max (const PedConstraint* constraint);

extern PedGeometry*
ped_constraint_solve_nearest (
	const PedConstraint* constraint, const PedGeometry* geom);

extern int
ped_constraint_is_solution (const PedConstraint* constraint,
			    const PedGeometry* geom);

extern PedConstraint*
ped_constraint_any (const PedDisk* disk);

extern PedConstraint*
ped_constraint_exact (const PedGeometry* geom);

extern const PedConstraint*	ped_constraint_none;

#endif /* PED_CONSTRAINT_H_INCLUDED */

