# Copyright (C) 2007-2009, Parrot Foundation.
# $Id: 23_string_ops_substr.pir 40124 2009-07-16 21:36:57Z allison $

=head1 String Operations (continued)

We can pick apart a string and pull substrings out of it using the
C<substr> command. C<substr> takes a string, a starting position and
optionally an ending position. It returns all the characters in
the string between the starting and ending positions. If the ending
position is left out, C<substr> returns all the characters until the
end of the string.

An optional fourth argument is a string that will be used to
replace the characters between the start and end positions.

=cut

.sub main :main

    $S0 = substr "abcde", 1, 2    # "bc"
    say $S0

    set $S1, "abcde"
    $S0 = substr $S1, 1, 2
    say $S0                   # "bc"
    say $S1                   # "abcde"

    set $S1, "abcde"
    $S0 = substr $S1, 1, 2, "XYZ"
    say $S0                       # "bc"
    say $S1                       # "aXYZde"

.end

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:

