=head1 NAME

App::Parcimonie::Role::HasCodeset - role to get the codeset being used

=head1 SYNOPSIS

    use MooseX::Declare;
    class App::Parcimonie::Daemon with App::Parcimonie::Role::HasCodeset {
      ...
    }

    See App::Parcimonie::Daemon for a real-life usage example.

=cut

package App::Parcimonie::Role::HasCodeset;
use Any::Moose 'Role';

our $VERSION = '0.7'; # VERSION

use namespace::autoclean;
use Try::Tiny;

has 'codeset'  => (
    isa        => 'Str',
    is         => 'ro',
    lazy_build => 1,
);

sub _build_codeset {
    my $codeset;
    try {
        require I18N::Langinfo;
        I18N::Langinfo->import(qw(langinfo CODESET));
        $codeset = langinfo(CODESET());
    } catch {
        die "No default character code set configured.\nPlease fix your locale settings.";
    };
    $codeset;
}

no Any::Moose 'Role';
1; # End of App::Parcimonie::Role::HasCodeset
