/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Texture2D;
import org.j3d.renderer.java3d.overlay.InputRequester;
import org.j3d.renderer.java3d.overlay.InteractiveOverlay;
import org.j3d.renderer.java3d.overlay.TextureOverlay;
import org.j3d.renderer.java3d.overlay.UpdateManager;

public class InteractiveTextureOverlay
extends TextureOverlay
implements InteractiveOverlay {
    private InputRequester requester;
    private ArrayList buffMouseList;
    private ArrayList buffMotionList;
    private ArrayList buffKeyList;

    public InteractiveTextureOverlay(Canvas3D canvas3D, Dimension dimension) {
        super(canvas3D, dimension);
        this.initLists();
    }

    public InteractiveTextureOverlay(Canvas3D canvas3D, Dimension dimension, Texture2D texture2D) {
        super(canvas3D, dimension, texture2D);
        this.initLists();
    }

    public InteractiveTextureOverlay(Canvas3D canvas3D, Dimension dimension, boolean bl, UpdateManager updateManager, Texture2D texture2D) {
        super(canvas3D, dimension, bl, updateManager, texture2D);
        this.initLists();
    }

    public void setInputRequester(InputRequester inputRequester) {
        Object e;
        int n;
        this.requester = inputRequester;
        for (n = 0; n < this.buffMouseList.size(); ++n) {
            e = this.buffMouseList.get(n);
            this.requester.addMouseListener((MouseListener)e, this);
        }
        for (n = 0; n < this.buffMotionList.size(); ++n) {
            e = this.buffMotionList.get(n);
            this.requester.addMouseMotionListener((MouseMotionListener)e, this);
        }
        for (n = 0; n < this.buffKeyList.size(); ++n) {
            e = this.buffKeyList.get(n);
            this.requester.addKeyListener((KeyListener)e, this);
        }
        this.buffMouseList.clear();
        this.buffMotionList.clear();
        this.buffKeyList.clear();
    }

    private void initLists() {
        this.buffMouseList = new ArrayList();
        this.buffMotionList = new ArrayList();
        this.buffKeyList = new ArrayList();
    }

    public void requestFocus() {
        if (this.requester != null) {
            this.requester.requestFocus(this);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.requester != null) {
            this.requester.addMouseListener(mouseListener, this);
        } else {
            this.buffMouseList.add(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.requester != null) {
            this.requester.removeMouseListener(mouseListener, this);
        } else {
            this.buffMouseList.remove(mouseListener);
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.requester != null) {
            this.requester.addMouseMotionListener(mouseMotionListener, this);
        } else {
            this.buffMotionList.add(mouseMotionListener);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.requester != null) {
            this.requester.removeMouseMotionListener(mouseMotionListener, this);
        } else {
            this.buffMotionList.remove(mouseMotionListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.requester != null) {
            this.requester.addKeyListener(keyListener, this);
        } else {
            this.buffKeyList.add(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.requester != null) {
            this.requester.removeKeyListener(keyListener, this);
        } else {
            this.buffKeyList.remove(keyListener);
        }
    }
}

