/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_) 

Copyright 2008 SciberQuest Inc.
*/
#ifndef __pqSQProcessMonitor_h
#define __pqSQProcessMonitor_h

#include "pqNamedObjectPanel.h"

#include "ui_pqSQProcessMonitorForm.h"
using Ui::pqSQProcessMonitorForm;

#include <map>
using std::map;
#include <string>
using std::string;
#include  <vtkstd/vector>
using std::vector;

// Define the following to enable debug io
// #define pqSQProcessMonitorDEBUG

class pqProxy;
class vtkEventQtSlotConnect;
class QWidget;
class SystemInterface;
class HostData;
class RankData;


class pqSQProcessMonitor : public pqNamedObjectPanel
{
  Q_OBJECT
public:
  pqSQProcessMonitor(pqProxy* proxy, QWidget* p = NULL);
  ~pqSQProcessMonitor();
  void Restore();
  void Save();

protected slots:
  // Description:
  // Update the UI with values from the server.
  void PullServerConfig();

  // Description:
  // Update information events are generated by PV in many instances.
  // We need to watch for the ones coresponding to RequestInformation
  // on the server side where the new database view is stored in 
  // vtkInformation. This will take that information object
  // and load it in to the QTreeWidget.
  void UpdateInformationEvent();

  // Description:
  // Pull server load data.
  void UpdateServerLoad();

  // Description:
  // This is where we have to communicate our state to the server.
  void accept();

  // Description:
  // Manipulate command which can be run using fork/exec.
  void ExecCommand();
  void AddCommand();
  void DelCommand();
  void EditCommand(bool state);

  void IncrementInformationMTime();

  // Description:
  // Use when an artificial limit on per-process memory
  // consumption is in play, such as on a shared memory system.
  void OverrideCapacity();

private:
  void ClearServerHosts();
  void ClearClientHost();

private:
  pqSQProcessMonitorForm *Form;
  vtkEventQtSlotConnect *VTKConnect;
  int InformationMTime;

  int ServerType;
  map<string,HostData *> ServerHosts;
  vector<RankData *> ServerRanks;

  int ClientOnly;
  HostData *ClientHost;
  RankData *ClientRank;
  SystemInterface *ClientSystem;
};

// note:
// rank data is managed by host. 

#endif
