#!/bin/bash
# Geir Torstein Kristiansen <gtk@linux.online.no> 2000
# License is GPL
# Finds out what external commands a shell script relies on
# And automatically make a script to check if these are present
# on a system. You should should check the "mydeps" variable in the 
# generated script and remove any uneeded commands to check for
# there. After all, this script simply runs "which" on any single
# word in the script you wish to check for dependencies so naturally
# there may be some unwanted matches. There may also be matches for
# commands that are builtin in the shell itself if there also exists
# an external command of that name. 

# BUGS
# Slow and ugly hack but luckily not often used
# Does not find things inside of ` characters
# Probably more

file_exist () {
# checks if a file exists, that it is a regular file and readable.

if [ -z $1 ]; then
	echo "file_exist () called without an argument."
	exit 1
fi

if [ -f $1 -a -r $1 ]; then
	return 0
else
	echo "\"$1\" is not a regular file or not readable by you."
	exit 1
fi
}

findreq () {
while read f; do
	for i in $f; do
		i=`echo $i | sed s/\"/\ /g`
		case $i in
			-*)
			# do nothing to not confuse which
			;;
			*)
			
			if [ -z "$req" ]; then
				req=`which "$i" 2>/dev/null`
			else
				req="$req `which $i 2>/dev/null`"
			fi
			;;
		esac
	done
done <$1

fullpathdeps=`(for i in $req; do
        echo $i
done ) | sort | uniq`

for i in $fullpathdeps; do
	if [ -z "$deps" ]; then
		deps=`basename $i`
	else
		deps="$deps `basename $i`"
	fi
done

for i in $fullpathdeps; do
	echo $i >/dev/stderr
done
}

make_check_deps () {
echo '#!/bin/sh'

echo "mydeps=\"$deps\""

echo 'for i in $mydeps; do'
echo '	CPATH=`which $i 2>/dev/null`'
echo '	echo -n "checking for $i... "'
echo '		if [ -x "$CPATH" ]; then'
echo '			echo "$CPATH"'
echo '		else'
echo '			echo "WARNING! $i not found"'
echo '			err="1"'
echo '		fi'
echo 'done'
echo ''
echo 'if [ "$err" = "1" ]; then'
echo '    echo -e "\nUnsatisfied dependencies, your shell script may not function correctly."'
echo '    false'
echo 'else'
echo '    echo -e "\nThe dependencies for your shell script look OK."'
echo '    true'  
echo 'fi'
}

findreq $1
make_check_deps
