#ifndef INCLUDE_SPELLSTACKER_H
#define INCLUDE_SPELLSTACKER_H

#ifndef WIN32
#include <inttypes.h>
#endif

#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

struct stacker_command {
  char * cmd;
  struct stacker_command * next;
};

struct stacker_data {
  GtkWidget * widget;
  GtkWidget * frame;
  Connection * connection;

  uint16_t count;
  struct stacker_command * commands;
};

class G_MODULE_EXPORT SpellStacker : public Plugin {
 public:

  SpellStacker();
  ~SpellStacker();

  void input(Connection *, char *);
  void callback(Connection *, char *, void *);

  struct stacker_data * find_entry(Connection *);
  
 private:

  void sendCommand(Connection *, char *);

  typedef std::list<struct stacker_data *> StackerDataList;
  std::list<struct stacker_data *> stackerData;

  void updateDisplay(struct stacker_data *);

};


#endif // INCLUDE_SPELLSTACKER_H
