#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#include "Socket.h"
#include "Connection.h"
#include "TeloptFilter.h"
#include "VT.h"

VT::VT(Connection * c) {
  conn = c;
  /* Set the default mode. */
  mode = VTLineMode;
  initialise();
}

VT::~VT() {
}

void VT::initialise() {

  /**
     Features of all VTs:

       o tray to put plugin stuff into
       o box to insert own widgets into

   **/

  hbox1 = gtk_vbox_new(FALSE, 2);
  gtk_widget_show(hbox1);

  box = (GtkWidget *)gtk_frame_new((char *)NULL);
  gtk_widget_show(box);

  tray = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(tray);

  gtk_box_pack_start(GTK_BOX(hbox1), box, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox1), tray, FALSE, FALSE, 0);
  
  return;
}

void VT::addToTray(GtkWidget * w, GtkWidget ** frame) {

  // This could cause a leak unless there's a way to keep track of frames.
  *frame = gtk_frame_new((const gchar *)NULL);
  gtk_widget_show(*frame);

  gtk_container_add(GTK_CONTAINER(*frame), w);

  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(tray), *frame, FALSE, FALSE, 0);
}

void VT::removeFromTray(GtkWidget * w) {

  // Iterate through the items in GTK_BOX(tray)

  // Remove widget w and frame f.


}

void VT::removeFromTray(GtkWidget * w, GtkWidget * f) {
  gtk_container_remove(GTK_CONTAINER(tray), f);

  //   gtk_widget_destroy(f);

}

/**
 * Any text to be considered for the display will be sent to this method.
 * This includes prompts, which the VT must remove if it wishes to display
 * them in a separate area.
 */

void VT::append(char * text) {
  /* Generic VT append method so that VT can be used by itself. */
  printf(text);
}

void VT::scroll() {
}

void VT::setInput(char * s) {
}

GtkWidget * VT::getInput() {
  return (GtkWidget *)NULL;
}

void VT::setMode(VTMode m) {
  mode = m;
}

VTMode VT::getMode() {
  return mode;
}

/**
 * Tells the VT to claim focus on its input widget.
 *
 * gtk_widget_grab_focus(widget)
 */

void VT::focus() {
}

void VT::use() {
}

GtkWidget * VT::getMainWindow() {
  return hbox1;
}

GtkWidget * VT::getOutput() {
  return NULL;
}

void VT::prefsUpdated() {
}

void VT::hideCommands() {
}
void VT::showCommands() {
}
bool VT::showingCommands() {
    return true;
}

void VT::preInsert() {
}

int VT::width()
{
    return 80;
}

int VT::height()
{
    return 24;
}

void VT::sizeChanged()
{
    Socket *s = conn->getSocket();
    if (s)
    {
	// Do NAWS if enabled.
	TeloptFilter *filter = static_cast<TeloptFilter*>(s->inputFilters.findFilter("TelnetOptions"));
	filter->do_naws();
    }
}

void VT::scrollUp() {
}

void VT::scrollDown() {
}

void VT::keypressEvent(GtkWidget *, GdkEventKey *) {
}

struct colour_table * VT::getColourTable() {
  return NULL;
}
