#include <string.h>
#include <stdlib.h>

#include "papaya/system.h"
#include "FontChooser.h"
#include "Prefs.h"

FontChooser::FontChooser(char * font_string) {
  init(font_string);

  callback = NULL;
  callback_data = NULL;
}

FontChooser::FontChooser(char * font_string, ChangeCallback cb, gpointer data) {
  init(font_descriptor);

  callback = cb;
  callback_data = data;
}

void FontChooser::init(char * font_string) {
  if (font_string)
    font_descriptor = strdup(font_string);
  else
    font_descriptor = NULL;

  ui = gtk_table_new(1, 2, FALSE);
  gtk_widget_show(ui);
  gtk_table_set_col_spacings(GTK_TABLE(ui), 3);

  preview = gtk_entry_new();
  gtk_widget_show(preview);
  gtk_entry_set_text(GTK_ENTRY(preview), _("Sample: abcdefghijklmnopqrstuvwxyz"));
  gtk_editable_set_position(GTK_EDITABLE(preview), 0);
  gtk_table_attach(GTK_TABLE(ui), preview,
                   0, 1, 0, 1,
                   (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                   (GtkAttachOptions) (0), 0, 0);

  button = gtk_button_new_with_label(_("Change"));
  gtk_widget_show(button);
  gtk_table_attach(GTK_TABLE(ui), button,
                   1, 2, 0, 1,
                   (GtkAttachOptions) (0),
                   (GtkAttachOptions) (0), 0, 0);

  g_signal_connect_data(G_OBJECT(button), "clicked",
		   (GtkSignalFunc)font_chooser_open, this,
		   NULL, (GConnectFlags)0);

  g_object_set_data_full(G_OBJECT(ui), "C++ destructor", this,
			 font_chooser_destroy);

  updatePreview();

  chooser = NULL;
}

void FontChooser::updatePreview() {

  PangoFontDescription * font;

  font = pango_font_description_from_string(font_descriptor);
  gtk_widget_modify_font(preview, font);
  pango_font_description_free(font);
}

FontChooser::~FontChooser() {
  if (chooser != NULL) {
    gtk_widget_hide(chooser);
    gtk_widget_destroy(chooser);
    chooser = NULL;
  }

  if (font_descriptor) {
    free(font_descriptor);
	font_descriptor = NULL;
  }
}

GtkWidget * FontChooser::getUI() {
  return ui;
}

char * FontChooser::getFont() {
  return strdup(font_descriptor);
}

void FontChooser::setFont(char * font) {
  free(font_descriptor);
  font_descriptor = strdup(font);
  updatePreview();
}

void FontChooser::setSensitive(bool b) {
  gtk_widget_set_sensitive(button, b);
  gtk_widget_set_sensitive(preview, b);
  if (chooser) {
    gtk_widget_hide(chooser);
    gtk_widget_destroy(chooser);
    chooser = (GtkWidget *)NULL;
  }
}

gboolean font_chooser_open(GtkButton * button, gpointer data) {
  GtkWidget * cancel_button;
  GtkWidget * ok_button;  
  FontChooser * fc = (FontChooser *) data;

  if (fc->chooser) {
    // Already choosing this font
    gtk_window_present((GtkWindow *)fc->chooser);
    // We processed this, so don't let the parents handle it
    return TRUE;
  }

  fc->chooser = gtk_font_selection_dialog_new(_("Font Selection"));

  cancel_button = GTK_FONT_SELECTION_DIALOG (fc->chooser)->cancel_button;
  gtk_widget_show (cancel_button);
  g_signal_connect_data(G_OBJECT(cancel_button), "clicked",
			GTK_SIGNAL_FUNC(font_chooser_cancel), data,
			NULL, (GConnectFlags)0);

  ok_button = GTK_FONT_SELECTION_DIALOG (fc->chooser)->ok_button;
  gtk_widget_show (ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  g_signal_connect_data(G_OBJECT(ok_button), "clicked",
			GTK_SIGNAL_FUNC(font_chooser_ok), data,
			NULL, (GConnectFlags)0);
  g_signal_connect_data(G_OBJECT(fc->chooser), "delete-event",
			GTK_SIGNAL_FUNC(font_chooser_wm_close), fc,
			NULL, (GConnectFlags)0);

  gtk_font_selection_dialog_set_font_name(
                                        GTK_FONT_SELECTION_DIALOG(fc->chooser),
                                        fc->font_descriptor);

  gtk_widget_show(fc->chooser);

  return TRUE;
}

gboolean font_chooser_ok(GtkButton * button, gpointer data) {
  FontChooser * fc = (FontChooser *) data;
  char * temp = strdup(gtk_font_selection_dialog_get_font_name(
                                        GTK_FONT_SELECTION_DIALOG(fc->chooser)));

  if (temp) {
	if (fc->font_descriptor)
      free(fc->font_descriptor);

    fc->font_descriptor = temp;

    fc->updatePreview();
  }

  gtk_widget_hide(fc->chooser);
  gtk_widget_destroy(fc->chooser);
  fc->chooser = (GtkWidget *)NULL;

  if (fc->callback)
    fc->callback(fc, fc->callback_data);

  return TRUE;
}

gboolean font_chooser_cancel(GtkButton * button, gpointer data) {
  FontChooser * fc = (FontChooser *) data;

  gtk_widget_hide(fc->chooser);
  gtk_widget_destroy(fc->chooser);
  fc->chooser = (GtkWidget *)NULL;

  return TRUE;
}

gboolean font_chooser_wm_close(GtkWidget * widget, GdkEvent * event,
                                gpointer data) {
  FontChooser * fc = (FontChooser *) data;

  gtk_widget_hide(fc->chooser);
  gtk_widget_destroy(fc->chooser);
  fc->chooser = (GtkWidget *)NULL;

  return TRUE;
}

void font_chooser_destroy(gpointer font_chooser) {
  delete (FontChooser *) font_chooser;
}
