#include <string.h>
#include <stdio.h>

#include "EOLFilter.h"

EOLFilter::EOLFilter(Connection * s)
    : Filter(s, "End-Of-Line")
{
}

EOLFilter::~EOLFilter() {
}

// Converts:
// \n\r     -> \n
// \r\n     -> \n
// \r\0     -> \n
// \r       -> \n  (a lone \r is technically illegal, but..)

bool EOLFilter::process(Buffer &out)
{
    bool changed = false;
    char *start = input.getText();
    char *last = start;
    char *end = start + input.getLength();
    char *p = start;
    
    static char *nlstr = "\n";
    static char *tpstr = "\r";

    while ((p = (char*)memchr(p, '\r', end - p)) != NULL)
    {

      // was p > start
        if (p > last && p[-1] == '\n') {
	    // \n\r -> \n
	    changed = true;
	    out.append(last, p - last);
	    ++p;
	    last = p;
	}
	else if (p+1 < end && p[1] == '\n') {
	    // \r\n -> \n
	    changed = true;
	    out.append(last, p - last);
	    out.append(nlstr, 1);
	    last = p+2;
	    p += 2;
	}
	else if (p+1 < end && p[1] == '\0') { // was '\r'
	    // \r\0 -> \n
	    changed = true;
	    out.append(last, p - last);
	    out.append(tpstr, 1);
	    last = p+2;
	    p += 2;
	}
	else {
	    // Lone \r -> \n
	    changed = true;
	    out.append(last, p - last);
	    out.append(tpstr, 1);
	    last = p+1;
	    p += 1;
	}
    }

    if (!changed) // Fast path for no changes
	input.transfer_to(out);
    else // Final copy
    {
	out.append(last, end - last);
	input.reset();
    }

    return true;
}
