-- Testing laziness and infinite structures:

import Assertion

-- the list of natural numbers:
from n = n : from (n+1)

-- Fibonacci numbers:
fibs = fibgen 1 1
fibgen n1 n2 = n1 : fibgen n2 (n1+n2)

test1 = assertEqual "fibs" (take 10 fibs) [1,1,2,3,5,8,13,21,34,55]


-- the list of primes generated by the
-- Sieve of Erathostenes:
primes = sieve (from 2)
 
sieve (x:xs) = x : sieve (filter (\y -> y `mod` x > 0) xs)

test2 = assertEqual "primes" (take 5 primes) [2,3,5,7,11]


-- Hamming numbers:
ordMerge (x:xs) (y:ys) | x==y = x:ordMerge xs ys
                       | x<y  = x:ordMerge xs (y:ys)
                       | x>y  = y:ordMerge (x:xs) ys

hamming = 1:ordMerge (map (*2) hamming)
                     (ordMerge (map (*3) hamming)
                               (map (*5) hamming))

test3 = assertEqual "hamming" (take 10 hamming) [1,2,3,4,5,6,8,9,10,12]
