//
// C++ Interface: helpers
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __HELPERS_H_2004_06_23
#define __HELPERS_H_2004_06_23

#include <string>
#include <cctype>	// for tolower
#include <algorithm>

#include <qstring.h>

#include <iostream>

/** Converts the given string to a QString. This should mean no more overhead than
  * doing it manually. */
inline QString toQString(const std::string& str)
{
//	return QString(str);
//	return QString(str.c_str());
	return QString::fromStdString(str);
}

inline QString& toQString(QString& str)
{
	return str;
}

inline std::string toString(const QString& str)
{
//	return str.operator std::string();
	return std::string(str.toAscii());
}

/** Avoid accidental conversions like toString(str) where str already is a std::string */
inline std::string& toString(std::string& str)
{
	return str;
}


inline int myToLower(int a)
{
	return tolower(a);
}

inline void qStrDebug(const QString& string)
{
	qDebug(string.toAscii());
}

inline void qStrWarning(const QString& string)
{
	qWarning(string.toAscii());
}

/** @brief Makes the given string lower case - modifies the handed string.
  * @returns a reference to the transformed string (which is the one handed). */
inline std::string& makeLower(std::string& trans)
{
	std::transform(trans.begin(), trans.end(), trans.begin(), myToLower);
	return trans;
}

/** Creates a string that differs from the given one only in being lower case. */
inline std::string toLower(const std::string& in)
{
	using namespace std;
	string result;
	std::transform(in.begin(), in.end(), back_inserter(result), myToLower);
	return result;
}

/** Operator for outputting QStrings. */
inline std::ostream& operator<< (std::ostream& out, const QString& str) 
{
	out << str.toAscii().data();
	return out;
}

#endif	// __HELPERS_H_2004_06_23
