//
// C++ Interface: selectioninputanddisplay
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __SELECTIONINPUTANDDISPLAY_H_2004_06_28
#define __SELECTIONINPUTANDDISPLAY_H_2004_06_28

#include <qobject.h>
#include <q3listbox.h>
//Added by qt3to4:
#include <QLabel>

#include "tagselectionwidget.h"

class Q3ListBoxItem;
class QPoint;
class QLabel;

class TagItem;

namespace NWidgets {

/** @brief This class manages a TagSelectionListView and the corresponding listbox which displays 
  * the results.
  *  
  * It does not inherit QWidget itself.
  * @invariant _pTagSelection points to a valid object
  * @author Benjamin Mesing
  *
  * @developer The selectionInputAndDisplay widgets that will be created a will have 
  * be child of the pTagSelectionParent handed in the constructor and thus must not
  * be deleted via delete.
  */
class SelectionInputAndDisplay : public QObject
{
Q_OBJECT

	typedef ept::debtags::Facet Facet;

	/** @brief The widget used to select the tags.
	  *
	  * This widget will be created and managed by this class. */
	TagSelectionWidget* _pTagSelection;
	/** @brief The QListBox which should be used to show the tags selected. */
	Q3ListBox* _pTagView;
	/** @brief The label shown above #_pTagView. */
	QLabel* _pViewLabel;
	/** @brief The parent to be used for this class. */
	QWidget* _pParent;
public:
	/** 
	  * @param pParent the parent of this class
	  * @param pTagSelectionWidget the widget that shall be used to select the widgets
	  * @param pTagView the QListBox which should be used to show the tags selected
	  * @param pViewLabel the label shown above pTagView
	  * @param loadVocabulary if the vocabulary should be loaded, else the widget will stay
	  * empty
	  */
	SelectionInputAndDisplay(QWidget* pParent, const char *name, TagSelectionWidget* pTagSelection,
		Q3ListBox* pTagView, QLabel* pViewLabel);
	~SelectionInputAndDisplay();
	/** @brief For easy access to the tagSelectionListView. */
	TagSelectionListView* tagSelectionListView()	{ return _pTagSelection->tagSelection(); }
	TagSelectionWidget* tagSelectionWidget()		{ return _pTagSelection; }
public slots:
	/** @brief This shows or hides the widgets. 
	  *
	  * If a widget is hidden its vocabulary will be unloaded. 
	  * @warning if the widget is hidden it is not safe to access any member function
	  * except setShow(true) */
	void setShown(bool show);
	/** Clears the selected items. */
	void clear();
	/** @brief This reloads it the #_pTagSelection ListView widget by calling 
	  * tagSelectionListView()->loadVocabulary()
	  */
	void loadVocabulary(const std::set<Facet>& vocabulary);
protected slots:
	void onViewContextMenuRequested(Q3ListBoxItem* pItem, const QPoint& pos);
	/** This shows the handed tags in the #_pTagView. */
	void setViewTags( const set<TagItem*> & tags );
};

}	// namespace NWidgets

#endif	//  __SELECTIONINPUTANDDISPLAY_H_2004_06_28
