//
// C++ Implementation: runcommandinxterm
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <algorithm>
#include <functional>

#include <unistd.h>		// for getuid and geteuids
#include <sys/types.h>	//

#include <QFileInfo>
#include <qstring.h>
#include <qprocess.h>

// NApplication
#include "runcommandinxterm.h"

// NException
#include "exception.h"

#include <helpers.h>

namespace NApplication {



RunCommandInXterm::RunCommandInXterm()
{
	_pProcess=0;
}


RunCommandInXterm::~RunCommandInXterm()
{
	delete _pProcess;
}


void RunCommandInXterm::addArgument(const QString& arg)
{
	_arguments.push_back(arg);
}


bool RunCommandInXterm::start(bool root)
{
	QProcess* _pProcess = new QProcess(0);
	QString argumentString = _arguments.join(" ");

	QFileInfo xterm("/usr/bin/xterm");
	if (!xterm.isExecutable())
		xterm = QFileInfo("/usr/X11R6/bin/xterm");
	else if (!xterm.isExecutable())
		throw NException::RuntimeException("Neither /usr/bin/xterm nor /usr/X11R6/bin/xterm is executable/available");
	
	QFileInfo su("/bin/su");
	
	QFileInfo command(_arguments[0]);
	if (!command.isExecutable())
		throw NException::RuntimeException(toString("Program " + command.absoluteFilePath() + " not executable/available"));

	QStringList arguments;
	arguments.push_back("-T");
	arguments.push_back(argumentString);
	arguments.push_back("-e");
	// execute using the shell
	arguments.push_back("sh");
	arguments.push_back("-c");
	QString fullArgumentString;
	fullArgumentString += "(";
		if (root)
		{
			fullArgumentString += "echo \"Please enter root password\" ";
			fullArgumentString += "; su -c ";
			fullArgumentString += "\"" + argumentString + "\"";
		}
		else
		{
			fullArgumentString += argumentString;
		}
		
		fullArgumentString += "&& echo \"\nExecution completed successfully!\"";
	fullArgumentString += ")";
	fullArgumentString += "|| echo \"\nExecution failed. \"";
	fullArgumentString += "; echo \"Press Enter to close the XTerm\" ; read ";
	
	arguments.push_back(fullArgumentString);
	// forward the signal
	connect(_pProcess, SIGNAL(finished(int)), this, SLOT(onProcessExited()));
	_pProcess->start("xterm", arguments);
	return true;
}

bool RunCommandInXterm::start()
{
	return start(false);
}


bool RunCommandInXterm::startAsRoot()
{
	if (geteuid() != 0)
		return start(true);
	else 
		return start(false);
}


void RunCommandInXterm::onProcessExited()
{
	delete _pProcess;
	_pProcess = 0;
	emit processExited();
	emit quit();
}

};
