//
// C++ Implementation: selectioninputanddisplay
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <cassert>

#include <q3listbox.h>
#include <qmessagebox.h>
#include <q3popupmenu.h>
#include <qlabel.h>

#include <apt-front/cache/entity/tag.h>

#include "selectioninputanddisplay.h"

#include "helpers.h"
#include "tagselectionwidget.h"
#include "tagselectionlistview.h"

using namespace aptFront::cache::entity;

namespace NWidgets 
{

SelectionInputAndDisplay::SelectionInputAndDisplay (
	QWidget* pParent,
	const char *name, 
	TagSelectionWidget* pTagSelection, 
	Q3ListBox* pTagView, 
	QLabel* pViewLabel
)
 : QObject(pParent, name)
{
	_pParent = pParent;
	_pTagView = pTagView;
	_pViewLabel = pViewLabel;
	_pTagSelection = pTagSelection;
	
	connect(
		_pTagView, SIGNAL(contextMenuRequested(Q3ListBoxItem*, const QPoint&)),
		this, SLOT(onViewContextMenuRequested(Q3ListBoxItem*, const QPoint&))
	);
	// make the connection that changes in the tag selection are shown in the tag view
	connect(
		tagSelectionListView(), SIGNAL(tagItemsSelected(const set<TagItem*>&)),
		this, SLOT(setViewTags( const set<TagItem*>&))
	);
	_pTagView->setShown(false);
	_pViewLabel->setShown(false);

	/// @todo check if we must reenable loadVocabulary here
/*	if (loadVocabulary)
		this->loadVocabulary();*/
}


SelectionInputAndDisplay::~SelectionInputAndDisplay()
{
}

void SelectionInputAndDisplay::setShown(bool show)
{
	/// @todo check what to do here
	if (show)
	{
		// loadVocabulary();	// load the vocabulary data
	}
	else
	{
		tagSelectionListView()->clear();	// clear the vocabulary data
	}
	_pTagSelection->setShown(show);
}


void SelectionInputAndDisplay::clear()
{
	tagSelectionListView()->clear();
}

void SelectionInputAndDisplay::onViewContextMenuRequested(Q3ListBoxItem* pItem, const QPoint& pos)
{
	Q3PopupMenu menu(_pTagView);
	if (pItem)	// if clicked on an item
	{
		menu.insertItem("Remove", 0);
	}
	menu.insertItem("Clear", 1);
	switch (menu.exec(pos))
	{
		case 0:
			tagSelectionListView()->deselectTag(toString(pItem->text()));
			break;
		case 1:
			tagSelectionListView()->deselectAll();
			break;
		default:
			break;
	}
}

void SelectionInputAndDisplay::loadVocabulary(const Tagcoll::OpSet<Facet>& vocabulary)
{
	assert(_pTagSelection);
	tagSelectionListView()->loadVocabulary(vocabulary);	// load the new database
	_pTagSelection->setEnabled(true);
}


void SelectionInputAndDisplay::setViewTags( const set<TagItem*> & tags )
{
	_pTagView->clear();
	_pTagView->setShown(!tags.empty());
	_pViewLabel->setShown(!tags.empty());
	for (set<TagItem*>::const_iterator it = tags.begin(); it != tags.end(); ++it)
		_pTagView->insertItem( toQString((*it)->fullTagname()) );
	
}


}	// namespace NWidgets 
