//
// C++ Implementation: debtagssettingswidget
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "debtagssettingswidget.h"

// apt-front
#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/component/tags.h>


#include <helpers.h>

#include "exception.h"

using namespace aptFront::cache::component;
using namespace aptFront::cache::entity;

DebtagsSettingsWidget::DebtagsSettingsWidget(const set<string>& hiddenFacets, 
	QWidget *parent, const char *name)
 : QWidget(parent), Ui::DebtagsSettingsWidget()
{

	if (name)
		setObjectName(name);
	setupUi(this);

	Tags& tags = aptFront::cache::Global::get().tags();

	Tagcoll::OpSet<Facet> hidden;
	for (set<string>::const_iterator it = hiddenFacets.begin(); it != hiddenFacets.end(); it++)
	{
		Facet f = tags.facetByName(*it);
		if (f.valid())
			hidden += f;
	}
	Tagcoll::OpSet<Facet> facets = tags.facets();

	// iterate over all facets
	for ( Tagcoll::OpSet<Facet>::const_iterator it = facets.begin(); it != facets.end(); ++it )
	{
		const Facet& facet = *it;
		if ( hidden.find(facet) == hidden.end() ) // if the facet is not hidden
		// worked around gcc 4.1 not compiling this for an unknown reason
		// 		if ( !hidden.contains(facet) ) // if the facet is not hidden
		{
			new Q3ListViewItem(_pShownFacetsList, toQString(facet.name()), toQString(facet.shortDescription()));
		}
		else
		{
			new Q3ListViewItem(_pHiddenFacetsList, toQString(facet.name()), toQString(facet.shortDescription()));
		}
	}


}


DebtagsSettingsWidget::~DebtagsSettingsWidget()
{
}




void DebtagsSettingsWidget::on__pAddButton_clicked()
{
	Q3ListViewItemIterator it(_pShownFacetsList, Q3ListViewItemIterator::Selected);
	while ( it.current() ) 
	{
		Q3ListViewItem* pItem = (*it); // make a temporary copy of the item
		new Q3ListViewItem(_pHiddenFacetsList, pItem->text(0), pItem->text(1) );
		++it;
		emit facetHidden( toString(pItem->text(0)) );
		delete pItem;
	}
}

void DebtagsSettingsWidget::on__pRemoveButton_clicked()
{
	Q3ListViewItemIterator it(_pHiddenFacetsList, Q3ListViewItemIterator::Selected);
	while ( it.current() ) 
	{
		Q3ListViewItem* pItem = (*it); // make a temporary copy of the item
		new Q3ListViewItem(_pShownFacetsList, pItem->text(0), pItem->text(1) );
		++it;
		emit facetShown( toString(pItem->text(0)) );
		delete pItem;
	}
}

/** @brief This returns all facets that where selected to be hidden. */
set<string> DebtagsSettingsWidget::hiddenFacets()
{
	set<string> result;
	Q3ListViewItemIterator it(_pHiddenFacetsList);
	while ( it.current() ) 
	{
		result.insert( toString((*it)->text(0)) );
		++it;
	}
 return result;
}

/** @brief This returns all facets that where selected to be shown. */
set<string> DebtagsSettingsWidget::shownFacets()
{
	set<string> result;
	Q3ListViewItemIterator it(_pShownFacetsList);
	while ( it.current() ) 
	{
		result.insert( toString((*it)->text(0)) );
		++it;
	}
	return result;
}
