//
// C++ Interface: debtagsactionplugin
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NPLUGIN_DEBTAGSACTIONPLUGIN_H_2005_08_31
#define __NPLUGIN_DEBTAGSACTIONPLUGIN_H_2005_08_31

#include <actionplugin.h>

namespace NPlugin {

/**
@brief Offers the actions related to debtags

Currently the only action offered is used to perform debtags update.

@author Benjamin Mesing
*/
class DebtagsActionPlugin : public ActionPlugin
{
Q_OBJECT
	const QString _title;
	const QString _briefDescription;
	const QString _description;
	/** @brief Action used to update the debtags database. */
	Action* _pDebtagsUpdateAction;
	Action* _pSeparatorAction;
public:
	static const QString PLUGIN_NAME;
	DebtagsActionPlugin();
	~DebtagsActionPlugin();
	/** @name Plugin Interface
	  * 
	  * Implementation of the PluginInterface
	  */
	//@{
	virtual void init(IProvider* pProvider) {};
	/// @todo not yet implemented
	virtual void setEnabled(bool enabled)	{};
	/// @todo not yet implemented
	virtual void setVisible(bool visible)	{};
	virtual QString name() const { return PLUGIN_NAME; }
	virtual QString title() const { return _title; };
	virtual QString briefDescription() const { return _briefDescription; };
	virtual QString description() const { return _description; };
	//@}
	/** @brief Returns the QAction object for the #_pDebtagsUpdateAction. */
	QAction* qDebtagsUpdateAction() const { return _pDebtagsUpdateAction->action(); }

	/** @name ActionPlugin Interface
	  * 
	  * Implementation of the ActionPlugin Interface.
	  */
	//@{
	virtual vector<Action*> actions() const;
	//@}

};

}

#endif	// __NPLUGIN_DEBTAGSACTIONPLUGIN_H_2005_08_31
