//
// C++ Implementation: aptfrontpackagedb
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "aptfrontpackagedb.h"

#include <QStringList>

// NPlugin
#include <iprovider.h>
#include <packagenotfoundexception.h>

#include <helpers.h>



namespace NApt {

AptFrontPackageDB::AptFrontPackageDB(NPlugin::IProvider* pProvider) :
	_pProvider(pProvider),
	_currentPackage(aptFront::cache::entity::Package())
{
}


AptFrontPackageDB::~AptFrontPackageDB()
{
}


const AptFrontPackage& AptFrontPackageDB::getPackageRecord(const QString& pkg) const
{
	return getPackageRecord(toString(pkg));
}


const AptFrontPackage& AptFrontPackageDB::getPackageRecord(const string& package) const
{
	_currentPackage = AptFrontPackage
	(
		_pProvider->aptFrontCache().packages().packageByName(package)
	);
	if (!_currentPackage.isValid())
		throw NPlugin::PackageNotFoundException(package);
	return _currentPackage;
}

const QString AptFrontPackageDB::getShortDescription(const string& package) const
{
	return getPackageRecord(package).shortDescription();
}

Package::InstalledState AptFrontPackageDB::getState(const string& package) const
{
	return getPackageRecord(package).installedState();
}

void AptFrontPackageDB::reloadPackageInformation(NUtil::IProgressObserver* pObserver)
{
	_pProvider->reloadAptFrontCache();
}

int AptFrontPackageDB::getDescriptionCount(const string& package, const QString& pattern, bool caseSensitive) const
{
	return 1;
}
bool AptFrontPackageDB::matchesName(const string& package, const QString& pattern, bool caseSensitive) const
{
}



/////////////////////////////////////////////////////
// IAptSearch Interface
/////////////////////////////////////////////////////

bool AptFrontPackageDB::search(Tagcoll::OpSet<string>& result,
		const QString& pattern, bool searchDescr, bool caseSensitive) const
{

	aptFront::cache::component::Packages& packages = _pProvider->aptFrontCache().packages();
	for ( aptFront::cache::component::Packages::iterator it = packages.packagesBegin(); 
		it != packages.packagesEnd(); ++it )
	{
		const AptFrontPackage package(*it);
		if ( package.name().contains(pattern, caseSensitive) || 
				(searchDescr && package.description().contains(pattern, caseSensitive)))
		{
			result.insert(toString(package.name()));
		}
	}
	return result.empty();
}


bool AptFrontPackageDB::search(Tagcoll::OpSet<string>& result, const QStringList& includePatterns, 
	const QStringList& excludePatterns, bool searchDescr, bool caseSensitive) const
{
	aptFront::cache::component::Packages& packages = _pProvider->aptFrontCache().packages();
	for ( aptFront::cache::component::Packages::iterator it = packages.packagesBegin(); 
		it != packages.packagesEnd(); ++it )
	{
		const AptFrontPackage package(*it);
		// holds if the search matches the package
		bool included = true;
		// check if each included pattern occurs in the package
		for (QStringList::const_iterator jt = includePatterns.begin(); jt != includePatterns.end(); ++jt)
		{
			if ( !  ( package.name().contains(*jt, caseSensitive) ||
					    (searchDescr && package.description().contains(*jt, caseSensitive))
					  ) 
				)
			{
				included = false;
				break;
			}
		}
		if (!included)
			continue;
		// check if each excluded pattern does not occur in the package
		for (QStringList::const_iterator jt = excludePatterns.begin(); jt != excludePatterns.end(); ++jt)
		{
			if ( package.name().contains(*jt, caseSensitive) ||
				  (searchDescr && package.description().contains(*jt, caseSensitive))
				)
			{
				included = false;
				break;
			}
		}
		if (included)
			result.insert(toString(package.name()));
	}
	return result.empty();
}

}
