//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <iostream>

#include <qregexp.h>
#include <qstringlist.h>
//Added by qt3to4:
#include <Q3CString>


#include "package.h"

namespace NApt
{

/** Function object. */
class Squeeze
{
public:
	void operator()(QString& s)	
	{
		s.squeeze();
	}
};

QString Package::_emptyString("");

Package::Package()
{
	installedState = NOT_INSTALLED;
};
	
Package::Package(const QString& name)
{
	installedState = NOT_INSTALLED;
};


Package::Package(const QStringList& lines)
{
	installedState = NOT_INSTALLED;
	parseInformation(lines);
	
	// trim the strings to current length
/*	Squeeze squeeze;
	processEntries(squeeze);*/
}


void Package::parseInformation(const QStringList& lines)
{
	static map<QString, int> sectionToString;
	static bool sectionToStringInitialized=false;
	if (!sectionToStringInitialized)
	{	// init the map
		sectionToStringInitialized=true;
		sectionToString["Package"]= 0;
		sectionToString["Essential"]= &essential - &name;
		sectionToString["Priority"]=&priority - &name;
		sectionToString["Section"]=&section - &name;
		sectionToString["Installed-Size"]=&installedSize - &name;
		sectionToString["Maintainer"]=&maintainer - &name;
		sectionToString["Architecture"]=&architecture - &name;
		sectionToString["Source"]=&source - &name;
		sectionToString["Version"]=&version - &name;
		sectionToString["Replaces"]=&replaces - &name;
		sectionToString["Provides"]=&provides - &name;
		sectionToString["Pre-Depends"]=&preDepends - &name;
		sectionToString["Depends"]=&depends - &name;
		sectionToString["Recommends"]=&recommends - &name;
		sectionToString["Suggests"]=&suggests - &name;
		sectionToString["Conflicts"]=&conflicts - &name;
		sectionToString["Filename"]=&filename - &name;
		sectionToString["Size"]=&size - &name;
		sectionToString["MD5sum"]=&md5sum - &name;
		sectionToString["Conffiles"]=&conffiles - &name;
		sectionToString["Description"]=&description - &name;
	
// 		sectionToString["InstalledVersion"]=&installedVersion - &package;

	}

	// search all lines for the keywords
	QString dummy;
	// this is only for the case of an error, dummy should not be used in regular work
	QString* pCurrentSection = &dummy;
	for (QStringList::const_iterator it=lines.begin(); it!=lines.end(); ++it)
	{
		QString line = (*it);
		int col = line.find(':');
		QString key = line.left(col);
		if (key[0] == ' ') 	// if this is simply a line in another section (the description)
			col = -1;
		QString value = line.mid(col+2);
		if (col != -1)	// we have probably found a new section
		{
			map<QString, int>::iterator jt = sectionToString.find(key);
			// if it really is a new section i.e. its key is known
			if ( jt != sectionToString.end() )
			{
				pCurrentSection = &name + jt->second;	// point to the new section 
				if (pCurrentSection == &description)
					shortDescription = value;
				(*pCurrentSection) = value;
			}
			else	// attach to the current section
			{
// 				qDebug("Unknown Section: " + key);
				(*pCurrentSection) += "\n" + line;
			}
		}
		else	// attach to the current section
		{
			(*pCurrentSection) += "\n" + line;
		}
	}
	// trim the strings to current length
/*	Squeeze squeeze;
	processEntries(squeeze);*/
}

Package::BorderList Package::getPackageList(const QString& s)
{
	BorderList result;
	if (s.isEmpty())
		return result;
	pair<uint, uint> currentPair;
	// inWord and inPar (in paranthesis) can never both be true
	bool inWord=true;
	uint inPar=0;
	// a simple parser...
	currentPair.first=0;
	for (uint i=0; i<s.length(); ++i)
	{
		if (inWord)
		{
			if ( !s[i].isSpace() && s[i]!=',' && s[i]!='(')	// we are still in the word
				continue;
			// we have reached the first char after a word
			currentPair.second=i;
			result.push_back(currentPair);
			inWord=false;
			if (s[i]=='(')
				++inPar;
		}
		else
		{
			if (inPar != 0)
			{
				if (s[i]=='(')	// this should not happen cause we should not have nested parantheses
					++inPar;
				if (s[i]==')')
					--inPar;
			}
			else
			{
				if (s[i]=='(')
					++inPar;
				if (s[i].isLetterOrNumber() || s[i]=='-' || s[i]=='_')	// we have reached a new word
				{
					currentPair.first=i;
					inWord=true;
				}
			}
		}
	}
	// if we finished with a word
	if (inWord)
	{
		currentPair.second=s.length();
		result.push_back(currentPair);
	}
	return result;
}

} // namespace NApt
