#include "aptplugincontainer.h"

#include <QAction>
#include <qmessagebox.h>
#include <QMainWindow>

// NPlugin
#include <plugincontainer.h>
#include <iprogressobserver.h>
#include <iprovider.h>

// NUtil
#include <progressdisplaydlg.h>

// NApt
#include "dumpavailpackagedb.h"

// NApplication
#include "applicationfactory.h"
#include "runcommand.h"


// NPlugin
#include "aptpluginfactory.h"
#include "aptsearchplugin.h"
#include "aptactionplugin.h"
#include "packagestatusplugin.h"
#include "packagedescriptionplugin.h"
#include "installedversionplugin.h"
#include "availableversionplugin.h"

#include <helpers.h>


extern "C" 
{ 
	NPlugin::PluginContainer* new_aptplugin() 
	{
		return new NPlugin::AptPluginContainer;
	} 
	
	NPlugin::PluginInformation get_pluginInformation()
	{
		return NPlugin::PluginInformation("aptplugin", "2.0.2", "Benjamin Mesing");
	} 
}

namespace NPlugin
{

/////////////////////////////////////////////////////
// Constructors/ Destructors
/////////////////////////////////////////////////////

AptPluginContainer::AptPluginContainer( )
  : BasePluginContainer()
{ 
	addPlugin("AptSearchPlugin");
	addPlugin("AptActionPlugin");
	addPlugin("PackageStatusPlugin");
	addPlugin("PackageDescriptionPlugin");
	addPlugin("InstalledVersionPlugin");
	addPlugin("AvailableVersionPlugin");
	_pAptSearchPlugin = 0;
	_pAptActionPlugin = 0;
	_pPackageStatusPlugin = 0;
	_pPackageDescriptionPlugin = 0;
	_pInstalledVersionPlugin = 0;
	_pAvailableVersionPlugin = 0;
	
	
	_pPackageDB = 0;
}

 
AptPluginContainer::~AptPluginContainer( )
{
	delete pluginFactory();
	delete _pPackageDB;
}


/////////////////////////////////////////////////////
// Plugin Container Interface
/////////////////////////////////////////////////////
 
bool AptPluginContainer::init(IProvider* pProvider)
{
	NUtil::IProgressObserver* pObserver = pProvider->progressObserver();
	pObserver->setProgressRange(0, 97, true);
	_pPackageDB = new NApt::DumpAvailPackageDB(pObserver, pProvider->packages().size());
	BasePluginContainer::init(pProvider, new AptPluginFactory(pProvider, this, _pPackageDB, _pPackageDB));
	pObserver->setProgressRange(97, 98, true);
	_pAptSearchPlugin = dynamic_cast<AptSearchPlugin*>(requestPlugin("AptSearchPlugin"));
	_pAptActionPlugin = dynamic_cast<AptActionPlugin*>(requestPlugin("AptActionPlugin"));
	_pPackageStatusPlugin = dynamic_cast<PackageStatusPlugin*>(requestPlugin("PackageStatusPlugin"));
	pObserver->setProgressRange(98, 99, true);
	_pPackageDescriptionPlugin = dynamic_cast<PackageDescriptionPlugin*>(requestPlugin("PackageDescriptionPlugin"));
	_pInstalledVersionPlugin = dynamic_cast<InstalledVersionPlugin*>(requestPlugin("InstalledVersionPlugin"));
	_pAvailableVersionPlugin = dynamic_cast<AvailableVersionPlugin*>(requestPlugin("AvailableVersionPlugin"));
	pObserver->setProgressRange(99, 100, true);
	
	connect( _pAptActionPlugin->qAptUpdateAction(), SIGNAL(activated()), SLOT(onAptUpdate()) );
	connect( _pAptActionPlugin->qRealoadDbAction(), SIGNAL(activated()), SLOT(onReloadDb()) );

	return true;
}


/////////////////////////////////////////////////////
// IAptMediator Interface
/////////////////////////////////////////////////////

QStringList AptPluginContainer::searchPatterns()
{
	if (!_pAptSearchPlugin)
		return QStringList();
	return _pAptSearchPlugin->searchPatterns();
}

/////////////////////////////////////////////////////
// AptPluginContainer functions
/////////////////////////////////////////////////////

void AptPluginContainer::onAptUpdate()
{
	_pAptActionPlugin->qAptUpdateAction()->setEnabled(false);
	// this will fetch us the update of the db
	NApplication::ApplicationFactory fac;
	_pCommand = fac.getRunCommand("AptUpdateProcess");
	QString command = "/usr/bin/apt-get";
	QString arg1 = "update";
	connect(_pCommand, SIGNAL(quit()), SLOT(onAptUpdateFinished()) );
	_pCommand->addArgument(command);
	_pCommand->addArgument(arg1);
	try 
	{
		if ( !_pCommand->startAsRoot() )
		{
			provider()->reportError( tr("Command not executed"), tr("For an unknwon reason, the command could "
				"not be executed.") );
			delete _pCommand;
			_pCommand = 0;
			_pAptActionPlugin->qAptUpdateAction()->setEnabled(true);
		}
	}
	catch (const NException::RuntimeException& e)
	{
		provider()->reportError(tr("Command not executed"), toQString(e.description()));
		delete _pCommand;
		_pCommand = 0;
		_pAptActionPlugin->qAptUpdateAction()->setEnabled(true);
	}
}


void AptPluginContainer::onAptUpdateFinished()
{
	if (_pCommand->processExitedSuccessful())
	{
 		NUtil::ProgressDisplayDlg dlg(provider()->mainWindow(), "PluginProgressDlg", true);
		dlg.show();
		_pPackageDB->reloadPackageInformation(&dlg);
	}
	delete _pCommand;
	_pCommand = 0;
	_pAptActionPlugin->qAptUpdateAction()->setEnabled(true);
}

void AptPluginContainer::onReloadDb()
{
	NUtil::ProgressDisplayDlg dlg(provider()->mainWindow(), "PluginProgressDlg", true);
	dlg.show();
	_pPackageDB->reloadPackageInformation(&dlg);
}

}	// namespace NPlugin
