/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.EncodingName;
import com.jclark.xsl.sax.FileDestination;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class GenericDestination
implements Destination {
    private String _encoding;

    public String getEncoding() {
        return this._encoding;
    }

    protected void setEncoding(String encoding) {
        this._encoding = encoding == null ? "UTF-8" : EncodingName.toIana(encoding);
    }

    public boolean keepOpen() {
        return false;
    }

    public Writer getWriter(String contentType, String encoding) throws IOException, UnsupportedEncodingException {
        OutputStream out = this.getOutputStream(contentType, encoding);
        if (out == null) {
            throw new IOException("null outputStream");
        }
        return new OutputStreamWriter(out, EncodingName.toJava(this.getEncoding()));
    }

    public Destination resolve(String uri) {
        if (File.separatorChar != '/') {
            uri = uri.replace('/', File.separatorChar);
        }
        return new FileDestination(uri);
    }
}

