use strict;
use warnings;
use Module::Build;

my $build = Module::Build
  -> new(
	 create_readme      => 1,
	 ##create_makefile_pl => 'traditional',
	 license            => 'perl',
	 module_name        => 'Xray::Scattering',
	 dist_author        => 'Bruce Ravel <bravel AT bnl DOT gov>',
	 dist_abstract      => "Class methods for X-ray scattering data of the elements",
	 requires => {
		      'Chemistry::Elements' => 0,
		      'Math::Spline'	       => 0,
		     },
	 PL_files           => {
				'data/cromann.PL'  => 'data/cromann.db',
				'data/waaskirf.PL' => 'data/waaskirf.db',
			       },
	 db_files           => {
				'data/cromann.db'  => 'lib/Xray/Scattering/cromann.db',
				'data/waaskirf.db' => 'lib/Xray/Scattering/waaskirf.db',
			       },
	 recommends         => {},
	 sign               => 0,
	);
$build->add_build_element('db');
$build->create_build_script;

