/*
 * Copyright 2002,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 *  MemBufInputSource::MemBufInputSource()
 * 
 *
 * 
 * ALWAYS ADOPT BUFFER (I.E. MAKE A COPY OF IT) SINCE IT IS TAKEN FROM
 * PERL, AND WHO KNOWS WHAT WILL HAPPEN TO IT AFTER IT IS GIVEN TO THE
 * CONSTRUCTOR
 */

//
// Perl should ignore these arguments
//

// %typemap(in,numinputs=0) (unsigned int byteCount) "$1 = 0;" 

/*
 * These arguments are used to indicate that Xerces-C should
 *    adopt a resource being passed as an argument. We should
 *    *always* tell Xerces-C to adopt.
 */
%typemap(in,numinputs=0) const bool adoptFlag "$1 = true;"   // for Wrapper4InputSource
                                                             // and Wrapper4DOMInputSource
%typemap(in,numinputs=0) const bool adoptBuffer "$1 = true;" // for MemBufInputSource

/*
 * Scripting languages are not going to change the default memory manager
 *   so we always default this argument
 */
%typemap(in,numinputs=0) XERCES_CPP_NAMESPACE::MemoryManager* const  manager "$1 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;"

%typemap(in) (const XMLByte* const srcDocBytes, 
	      unsigned int byteCount) {
  if (SvPOK($input)||SvIOK($input)||SvNOK($input)) {
    STRLEN len;
    XMLByte *xmlbytes = (XMLByte *)SvPV($input, len);
    $2 = len;
    $1 = new XMLByte[len];
    memcpy($1, xmlbytes, len);
  } else {
    SWIG_croak("Type error in argument 2 of $symname, Expected perl-string.");
  }
}

// XMLByte arrays are just char*'s
%apply char * {  XMLByte * }

/*
 * Adopting a validator
 *
 *   we have to disown the validator, because Xerces will adopt it
 *   first we create a temp variable to store it's value in the
 *   'in' typemap, and the after all conversion has succeeded
 *   the 'check' typemap will disown it.
 */
%typemap(in) XERCES_CPP_NAMESPACE::XMLValidator* valToAdopt (SV *temp)
{
        temp = $input;
	if (SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor,0) < 0) {
            SWIG_type_error("$1_mangle",$argnum,"$symname")
        }
}
%typemap(check) XERCES_CPP_NAMESPACE::XMLValidator* valToAdopt
{
   SWIG_Disown(temp$argnum);
}

/*
 * Dynamic Casts
 * 
 *   This very cool SWIG feature enables use to return the correct object
 *   type to Perl when a C++ method is defined as returning a base class
 *   object. We define a method that tells what type subclass the object
 *   is in.
 */

/*
 * Grammar*
 */

%typemap(out) XERCES_CPP_NAMESPACE::Grammar * = SWIGTYPE *DYNAMIC;

DYNAMIC_CAST(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, Grammar_dynamic_cast);

%{
static swig_type_info *
Grammar_dynamic_cast(void **ptr) {
   Grammar **nptr = (Grammar **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getGrammarType();
   if (type == Grammar::DTDGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar;
   }
   if (type == Grammar::SchemaGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar;
   }
   return NULL;
}
%}


/*
 * PerlCallbackHandler* - this is broken and useless
 */

%typemap(out) XERCES_CPP_NAMESPACE::PerlCallbackHandler * = SWIGTYPE *DYNAMIC;

DYNAMIC_CAST(SWIGTYPE_p_PerlCallbackHandler, PerlCallbackHandler_dynamic_cast);

%{
static swig_type_info *
PerlCallbackHandler_dynamic_cast(void **ptr) {
   PerlCallbackHandler **nptr = (PerlCallbackHandler **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->type();
   if (type == PERLCALLBACKHANDLER_BASE_TYPE) {
      die("Can't cast a PerlCallbackHandler base type node\n");
   }
   if (type == PERLCALLBACKHANDLER_ERROR_TYPE) {
      return SWIGTYPE_p_PerlErrorCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_ENTITY_TYPE) {
      return SWIGTYPE_p_PerlEntityResolverHandler;
   }
   if (type == PERLCALLBACKHANDLER_CONTENT_TYPE) {
      return SWIGTYPE_p_PerlContentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_DOCUMENT_TYPE) {
      return SWIGTYPE_p_PerlDocumentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_NODE_TYPE) {
      return SWIGTYPE_p_PerlNodeFilterCallbackHandler;
   }
   return NULL;
}
%}

/*
 * DOM_Node*
 */

%typemap(out) XERCES_CPP_NAMESPACE::DOMNode * = SWIGTYPE *DYNAMIC;

DYNAMIC_CAST(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, DOMNode_dynamic_cast);

%{
static swig_type_info *
DOMNode_dynamic_cast(void **ptr) {
   DOMNode **nptr = (DOMNode **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getNodeType();
   if (type == DOMNode::TEXT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMText;
   }
   if (type == DOMNode::PROCESSING_INSTRUCTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMProcessingInstruction;
   }
   if (type == DOMNode::DOCUMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument;
   }
   if (type == DOMNode::ELEMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement;
   }
   if (type == DOMNode::ENTITY_REFERENCE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityReference;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::COMMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMComment;
   }
   if (type == DOMNode::DOCUMENT_TYPE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentType;
   }
   if (type == DOMNode::ENTITY_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntity;
   }
   if (type == DOMNode::ATTRIBUTE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr;
   }
   if (type == DOMNode::NOTATION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNotation;
   }
   return NULL;
}
%}

