
/*
 *
 * Edscott Wilson Garcia 2001-2005 for xfce project.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



static xfmime_icon_functions *xfmime_icon_fun=NULL;
static GHashTable *theme_hash = NULL;
static GHashTable *icon_hash = NULL;
static GtkIconFactory *icon_factory = NULL;
static gchar *icon_theme_name=NULL;


/* this checks for the existence of the xxx.mime.xml file, which associates
 * filenames with mimetypes... (may be created with xfmime-edit) */

/* FIXME: create a fallback xml file for iconname/mimetype association
 * (freedesktop iconnaming spec) and use this as well as any user specified
 * file created with xfmime-edit.
 * 
 * */

static gboolean is_valid_theme_dir(gchar *theme_dir){
    gchar *b=g_path_get_basename(theme_dir);
    gchar *g=g_strconcat(PACKAGE_DATA_DIR,G_DIR_SEPARATOR_S,
	    "xffm",G_DIR_SEPARATOR_S,
	    b,".mime.xml",NULL);
	/*printf("is_valid_theme_dir --->%s? \n",theme_dir);
	printf("is_valid_theme --->%s? \n",g);*/
    if (!g_file_test(theme_dir,G_FILE_TEST_IS_DIR)) return FALSE;
    if (g_file_test(g,G_FILE_TEST_EXISTS)){
        g_free(g);
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	return TRUE;
    } else {
	g_free(g);
	g=mime_icon_get_local_xml_file(theme_dir);
        if (g_file_test(g,G_FILE_TEST_EXISTS)){
	/*printf("is_valid_theme_dir --->%s? yes\n",g);*/
	  g_free(g); 
	  return TRUE;	   
        }
        g_free(g); 
    }
    return FALSE;
}
static void start_element (GMarkupParseContext *context,
                          const gchar         *element_name,
                          const gchar        **attribute_names,
                          const gchar        **attribute_values,
                          gpointer             user_data,
                          GError             **error){
    int i;
    gchar *name=NULL,*icon=NULL;
      /*printf("start -> %s\n",element_name);*/
      /* here we should have the type and icon attributes set,
       * but they are not :-(
       * */
    if (strcmp(element_name,"mime-type")) return;
    if (attribute_names) {
	for (i=0;attribute_names[i];i++) 
	  if (attribute_names[0] && attribute_values[0]) 
	      name=g_strdup(attribute_values[0]);
	  if (attribute_names[1] && attribute_values[1]) 
	      icon=g_strdup(attribute_values[1]);
	  
          if (name && icon) {
		g_hash_table_insert(icon_hash, name, (gpointer) icon);
	      TRACE("hashing %s=%s\n",name,icon);
	  }
	  else if (name) {	      
	      TRACE("no icon defined for %s\n",name);
	      g_free(name);
	  }

      }
      return;
  }

static gchar **mime_icon_get_inherits(const gchar *theme){
    const gchar *theme_path;
    gchar **inherits=NULL;
    GKeyFile *key_file;
    GError *error=NULL;
    gchar *themeindex;
    gchar *value;

    theme_path=mime_icon_get_theme_path(theme);
    if (!theme) return NULL;
     
	
    TRACE("inherit themepath=%s\n",theme_path);
       
    /* inherited paths... */
	   
    key_file=g_key_file_new ();
    themeindex = g_build_path(G_DIR_SEPARATOR_S, theme_path, "index.theme", NULL);
    
    if (!g_key_file_load_from_file (key_file, themeindex, 0, &error)){
	g_error_free(error);
	g_key_file_free (key_file);
        g_free(themeindex);
	return NULL;
    }
    g_free(themeindex);
    value=g_key_file_get_string (key_file,"Icon Theme","Inherits",&error);
    if (error){
	g_key_file_free (key_file);
	g_error_free(error);
	return NULL;
    }
    g_key_file_free (key_file);
    TRACE("inherits=%s",value);
    inherits=breakdown_value(value);
    g_free(value);
    return inherits;
}


static void clear_iconhash(gpointer key, gpointer value, gpointer user_data)
{
    if (key) g_free(key);
    if (value) g_free(value);
}




static void glib_parser(const gchar *mimefile){
  FILE *f;
  size_t l;
  gchar line[81];
  GMarkupParseContext *context; 
  GError *error=NULL; 
  GMarkupParser parser={
      start_element,
      NULL, 
      NULL, /*text_fun,*/
      NULL,
      NULL
  };
  gpointer user_data=NULL;

  DBG("parsing %s",mimefile);
  context=g_markup_parse_context_new(&parser,0,user_data,NULL);
  f=fopen(mimefile,"r");
  if (!f){
      printf("sh*t, cannot open %s\n",mimefile);
      return;
  }
  while(!feof(f) && (l=fread(line,1,80,f))!=0) {
      line[l]=0;
      g_markup_parse_context_parse (context,line,l,&error);
  }
  fclose(f);
  
  g_markup_parse_context_free (context);
}

static int create_icon_hash(const gchar *mimefile){

    theme_info_t *theme_info;  

    TRACE("create_icon_hash...\n");
    if (!mimefile) {
	g_warning("create_icon_hash: mimefile cannot be NULL!");
	return 0;
    }

    /*g_free(icon_theme_name);*/

    
    if (theme_hash==NULL) {
	    DBG("creating new theme_hash...\n");
	    theme_hash = g_hash_table_new(g_str_hash, g_str_equal);
    }

    theme_info = g_hash_table_lookup(theme_hash,icon_theme_name);
    if (!theme_info){
        DBG("creating new icon hash and factory for %s\n",icon_theme_name);
	theme_info = (theme_info_t *)malloc(sizeof(theme_info_t));
    	theme_info->icon_hash = icon_hash = g_hash_table_new(g_str_hash, g_str_equal);
    	theme_info->icon_factory = icon_factory = gtk_icon_factory_new();
	g_hash_table_insert(theme_hash, g_strdup(icon_theme_name), (gpointer) theme_info);	
    } 
    else {
	    icon_hash = theme_info->icon_hash;
	    icon_factory = theme_info->icon_factory;
	    return 1;
    }
    
    
    glib_parser(mimefile);
    DBG("theme_hash created for %s!\n",icon_theme_name);
    return 1;
}




/**********************************************************************************************/

