
#ifndef __XFFM_TYPES_H__
#define __XFFM_TYPES_H__
#include <gtk/gtk.h>
#include <time.h>
#include <sys/types.h>

/* increment this MACRO whenever any change is done to structures
 * (to avoid incorrect memory accesses by modules)
 * Must be an integer. 
 * */
#define LIBXFFM_SERIAL 14

#define  LIBXFFM_MODULE void *module_sanity(void){return (GINT_TO_POINTER(LIBXFFM_SERIAL));}



#define TREEVIEW_TYPE 0x01
#define ICONVIEW_TYPE 0x02
#define DESKVIEW_TYPE 0x04

/* Two step input stuff */
enum
{
    OTHER_INPUT,
    GOTO_INPUT,
    RUN_INPUT,
    RUN_DOUBLE_CLICK,
    PRINT_INPUT,
    NEW_INPUT,
    NEW_FILE_INPUT,
    NEW_DIR_INPUT,
    RENAME_INPUT,
    DUPLICATE_INPUT,
    SYMLINK_INPUT,
    SCRAMBLE_INPUT,
    UNSCRAMBLE_INPUT,
    WORKDIR_INPUT,
    OPEN_BOOK_INPUT,
    SAVE_BOOK_INPUT,
    NEW_BOOK_INPUT,
    NEW_WIN_INPUT,
    NEW_BOOK_WIN_INPUT,
    NEW_TERM_INPUT,
    FREQUENCY_INPUT,
};

typedef struct record_entry_t	/* was: record_entry_t */ 
{
    gint type;			
    gint subtype;
    gint count;		        /* only for directories */
    struct stat *st;
    gchar *tag;
    gchar *path;
    gchar *icon;	/* for desktop entries */
    gchar *exec;	/* for desktop entries */
    int terminal;	/* for desktop entries */
    gchar *URL;		/* for desktop entries */
    gchar *filter;		/* filter for directories, path for trash */
    const gchar *module;	/* module name, or NULL for local files */
    off_t checksum;		/* only for directories */
    time_t load_time;
}
record_entry_t;

typedef struct widgets_t { /* 4.3.3.12 */
    gboolean		stop;
    guint		type;
    gint 		input;
    gint		not_used01;
    gint		not_used02;
    gint		not_used03;

    /* pointers: */
    void		*tubo_object;
    void 		*parent;
    void		*data;
    void		*combo_info;
    void		*filter_combo_info;

    GtkWidget 		*window;
    GtkWidget 		*remove;
    GtkWidget 		*diagnostics;
    GtkWidget 		*status;
    GtkWidget 		*progress;
    GtkWidget 		*vpane;
    GtkWidget 		*button_space;
    GtkWidget 		*stop_button;
    GtkWidget 		*clear_button;
    GtkTooltips 	*tooltips;
    GtkWidget		*diagnostics_window;
    
    gchar		*workdir;
    void		*not_used13;
    void		*not_used14;
    void		*not_used15;
    void		*not_used16;
    void		*not_used17;
    void		*not_used18;
    void		*not_used19;

    /* functions: */
    gint		(*refresh)(struct widgets_t *widgets_p);
    gint		(*refresh_parent)(struct widgets_t *widgets_p);
    record_entry_t	*(*get_selected_entry)(struct widgets_t *widgets_p);
    record_entry_t	*(*get_selected_parent_entry)(struct widgets_t *widgets_p);
    void 		(*open_with)(struct widgets_t *widgets_p, record_entry_t *en);
    
    void 		(*back_activate)(GtkMenuItem * menuitem, gpointer user_data);
    void		*not_used22;
    void		*not_used23;
    void		*not_used24;
    void		*not_used25;
    void		*not_used26;
    void		*not_used27;
    void		*not_used28;
    void		*not_used29;
    
} widgets_t;


typedef struct dir_t
{
    char *pathv;		/* matched pathname.  */
    record_entry_t *en;

}
dir_t;


typedef struct xfdir_t
{
    size_t pathc;		/* Count of paths matched */
    dir_t *gl;
}
xfdir_t;



/****************************************************************/
/*  treeview types: these are part of the structural design.
 *                  Eventually they will be private to treeview GUI
 *  *************************************************************/


typedef struct root_t
{
    int id;
    char *path;
    char *label;
    unsigned int type;
}
root_t;

/* only 2 treeview supported  */
enum
{
    RIGHT_TREEVIEW,
    LEFT_TREEVIEW,
    TREECOUNT
};

enum
{
    EMPTY_COLUMN,
    ENTRY_COLUMN,
    STYLE_COLUMN,
    FONT_COLUMN,
    SFONT_COLUMN,
    EDITABLE_COLUMN,
    COLOUR_COLUMN,
    WEIGHT_COLUMN,

    PIXBUF_COLUMN,
    NAME_COLUMN,
    SIZE_COLUMN,
    DATE_COLUMN,
    OWNER_COLUMN,
    GROUP_COLUMN,
    MODE_COLUMN,

    TREE_COLUMNS
};

typedef struct golist
{
    struct golist *previous;
    struct golist *next;
    char *path;
}
golist;

typedef struct treestuff_t {
    GtkTreeView *treeview;
    GtkTreeModel *treemodel;
    GtkTreeSortable *sortable;
    GtkTreeSelection *selection;

    GtkTreeViewColumn *column[TREE_COLUMNS];
    unsigned preferences;
    golist *gogo;
    gint ascending;
    gint sort_column;
    gint name_size;
}treestuff_t;

typedef struct arbol_t
{
    widgets_t widgets;
    gint  geometryX;
    gint  geometryY;
    gint  hpane;
    double hpane_ratio;
    /* smart button status */
    GHashTable *smart_hash;
    /* individual treeview information */
    treestuff_t treestuff[TREECOUNT];
    /* process variables */    
    gint selectionOK;
    gboolean loading;
    gchar *sidebar;
    gint relative_one;
    /* public functions usable by plugins: */
    void (*double_click_open_with)(record_entry_t *en);
    int (*get_active_tree_id)(void);
    int (*get_module_root)(GtkTreeView * treeview, GtkTreeIter * iter, record_entry_t ** en, const gchar *which);
    void (*hide_branch_activate) (GtkMenuItem *menuitem, gpointer user_data);
    gboolean (*prune_row)(GtkTreeModel *treemodel,GtkTreeIter *iter,GtkTreeRowReference *reference,record_entry_t *en);
    gboolean (*add_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference, GtkTreeIter *child_iter, record_entry_t * child_en, gchar *child_name);
    void (*add_contents_row)(GtkTreeModel *treemodel, GtkTreeIter * iter, xfdir_t * xfdir);
    gboolean (*remove_row)(GtkTreeModel *treemodel,GtkTreeIter *iter,GtkTreeRowReference *reference,record_entry_t *en);

    void (*erase_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference);
    void (*insert_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter, GtkTreeRowReference *parent_reference, record_entry_t *parent_en, gchar *icon_id, gchar *text);
    void (*reset_dummy_row)(GtkTreeModel *treemodel, GtkTreeIter *parent_iter,GtkTreeRowReference *parent_reference,record_entry_t *parent_en,gchar *icon_id, gchar *text);
    gboolean (*set_load_wait)(void);
    gboolean (*unset_load_wait)(void);
    gboolean (*find_module_root)(GtkTreeView * treeview,GtkTreeIter *iter,  record_entry_t ** en, const gchar *module_name);
    void (*update_icon)(GtkTreeModel * model, GtkTreeIter * iterator);
    void (*set_icon) (GtkTreeModel *treemodel, GtkTreeIter * iterator);
    gint (*local_monitor)(gboolean force);
    gboolean (*get_selectpath_iter)(GtkTreeIter * iter, record_entry_t ** en);

}arbol_t;


/****************************************************************/
/*  main types: 4.3.4
 *  *************************************************************/
typedef struct xffm_details_t
{
  gint timer;  /* place to park the id for monitoring function */
  guint32 eventtime;  /* place to park eventtime for button_press event */  
  GList *selection_list; /* list of record entries representing gui selection*/
  unsigned preferences; /* preferences for single widget gui's */
  int argc; /* partial argument list */
  gchar **argv; /* partial argument list */
  gchar *pastepath; /* set this on paste command to target path */
  int comm;  
  int unused01; /* available */
  int unused02; /* available */
  gpointer widget; /* used */
  GList **widgets_p_list_p ; /* used */
  /* Privatize (eventually): */
  arbol_t *arbol;
}
xffm_details_t;


#endif
