#ifndef XFFM_PRIMARY_H
#define XFFM_PRIMARY_H
#include <regex.h>
#include <errno.h>
#include <pwd.h>
#include <X11/Xmd.h>
#include <X11/SM/SMlib.h>

#include "glade_support.h"
#include "primary-modules.h"
#include "primary-icons.h"
#include "primary-misc.h"
#include "ls.h"
#include "uri.h"

void smc_set_properties(gint argc, gchar **argv, CARD8 style_hint);
void smc_connect(gint argc, gchar **argv, CARD8 style_hint);
const gchar *xdg_themes_dir(void);
const gchar *xdg_config_dir(void);
const gchar *xdg_cache_dir(void);

const gchar *bindlibxffm(void);
    
GtkWidget *
mk_little_button(	widgets_t *widgets_p,
			const gchar *icon_id,
			void * callback, 
			void *callback_data,
			const gchar *tooltip_text);

gchar ** 
text_type_OK(			const gchar *path);

/* hide/show stuff */
#define showit(x,y) gtk_widget_show_all(lookup_widget(x,y))
#define hideit(x,y) gtk_widget_hide_all(lookup_widget(x,y))

#ifdef XFFM_PRIMARY_C
G_MODULE_EXPORT
xffm_details_t *xffm_details=NULL;
/* the size of env_string must coincide with that of env_vars! */
G_MODULE_EXPORT
gchar *env_string[25]={
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL
};
G_MODULE_EXPORT
char *env_vars[25]={
    /* set by mcs manager buttons*/
	"XFFM_DEFAULT_UNLINK",		/* 1 */
	"XFFM_USE_SUDO",		/* 2 */

    /* mcs manager listing */
	"TERMCMD",			/* 3 */
	"EDITORCMD",			/* 4 */
	"DESKTOP_DIR",			/* 5 */
	"DESKTOP_COLOR",		/* 6 */
	"DESKTOP_BACKGROUND_IMAGE",	/* 7 */
	"USE_DESKTOP_MENU",		/* 8 */
	"USE_DESKTOP_MENU_ICONS",	/* 9 */
	"DISABLE_DESKTOP",		/* 10*/
	"SMB_USER",			/* 11*/
	"XFFM_SINGLE_CLICK_NAVIGATION",	/* 12*/
	"XFFM_DRAG_DOES_COPY",		/* 13*/
	"XFFM_FORCE_DIAGNOSTICS",	/* 14*/
	"XFFM_DISABLE_DIAGNOSTICS",	/* 15*/
	"XFFM_DISABLE_MONITOR",		/* 16*/
	"XFFM_DISABLE_TEXTCOLORS",	/* 17*/
	"XFFM_DISABLE_CELL_EDIT",	/* 18*/
	"XFFM_DISABLE_TIPS",		/* 19*/
	"XFFM_DEFAULT_EDITOR",		/* 20*/
	"XFFM_MAX_PREVIEW_SIZE",	/* 21*/
	"XFFM_ICON_THEME",		/* 22*/
	"XFFM_ICON_THEME",		/* 23*/
    /* internally used envar */
	"PWD",				/* 24*/
	NULL				/* 25*/
};

#else
extern xffm_details_t *xffm_details;
extern gchar *env_string[];
extern char *env_vars[];
#endif
void set_ascending(int asc);
void set_sort_column(int column);

void 	
init_xffm_env(		void);

void 
xffm_setenv(		const char *name,
			char *value,
			gboolean verbose);

/* entries */
gint 
entry_compare(		int caso,
			record_entry_t *en_a,
			record_entry_t *en_b);

record_entry_t *
copy_entry(record_entry_t *src_en);

void 
destroy_entry(		record_entry_t * en);

record_entry_t *
mk_entry(		int type);

record_entry_t *
mk_entry_path(		const gchar *path, 
			int type);

record_entry_t *
stat_entry(		const gchar *path, 
			int type);

record_entry_t *
mk_net_entry(		const gchar *path,
			unsigned type);

void 
set_entry_tag(			record_entry_t * en, 
				off_t tama);

/* gui */

void 
set_processing_pending(		void);

void 
unset_processing_pending(	void);

gboolean 
processing_pending(		void);

void 
process_pending_gtk();

void 
cursor_wait(	GtkWidget *w);

void 
cursor_reset(	GtkWidget *w);

/* local files */
gint 
count_files(			gchar *path);

gboolean 
get_xfdir_local(	xfdir_t *xfdir_p,
			record_entry_t *en,
			const gchar *filter);

void rm_cache_local(	const gchar *directory);

void 
xfdirfree(		xfdir_t * xfdir);

int
xfdir_compare(		const void *a, 
			const void *b);

regex_t *
get_regex_filter(record_entry_t * en);

const regex_t *
compile_regex_filter(		const gchar *filter,
				gboolean shows_hidden);

gint 
all_files_count(		void);

const gchar *
get_local_cache_path(gchar *directory);

gboolean 
update_check(record_entry_t *en);

#ifdef DEBUG
const gchar *
profile(void);
#endif

#endif
