/*
 * Definitions for libvshadow
 *
 * Copyright (C) 2011-2017, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBVSHADOW_DEFINITIONS_H )
#define _LIBVSHADOW_DEFINITIONS_H

#include <libvshadow/types.h>

#define LIBVSHADOW_VERSION			20170715

/* The version string
 */
#define LIBVSHADOW_VERSION_STRING		"20170715"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBVSHADOW_ACCESS_FLAGS
{
	LIBVSHADOW_ACCESS_FLAG_READ		= 0x01,
/* Reserved: not supported yet */
	LIBVSHADOW_ACCESS_FLAG_WRITE		= 0x02
};

/* The file access macros
 */
#define LIBVSHADOW_OPEN_READ			( LIBVSHADOW_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBVSHADOW_OPEN_WRITE			( LIBVSHADOW_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBVSHADOW_OPEN_READ_WRITE		( LIBVSHADOW_ACCESS_FLAG_READ | LIBVSHADOW_ACCESS_FLAG_WRITE )

/* The block flags
 */
enum LIBVSHADOW_BLOCK_FLAGS
{
	LIBVSHADOW_BLOCK_FLAG_IS_FORWARDER	= 0x00000001UL,
	LIBVSHADOW_BLOCK_FLAG_IS_OVERLAY	= 0x00000002UL,
	LIBVSHADOW_BLOCK_FLAG_NOT_USED		= 0x00000004UL
};

#endif /* !defined( _LIBVSHADOW_DEFINITIONS_H ) */

