/*
** timelaggednetwork.hh
** Login : <nico@Altarion.marmotte.ath.cx>
** Started on  Sat Jul 19 18:58:34 2003 Nicolas
** $Id: timelaggednetwork.hh,v 1.11 2003/09/16 08:56:55 nico Exp $
**
** Copyright (C) 2003 Nicolas
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU Lesser General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef   	TIMELAGGEDNETWORK_HH_
# define   	TIMELAGGEDNETWORK_HH_

# include "timelaggedneuron.hh"
# include "neuralnet.hh"

namespace NeuralNet
{
  typedef std::vector<std::vector<float> > NNdata_t;

  class TimeLaggedNeuralNet: public NeuralNet
  {
  public:
    TimeLaggedNeuralNet(const std::vector<unsigned int>& nb,
			const std::vector<unsigned>& winsize,
			ActivationFunctionType type,
			ActivationFunctionType typeout);

    TimeLaggedNeuralNet(const std::string& file);

  public:
    float trainNetwork(const NNdata_t& inputs, bool batch, TrainingAlgorithm algo);
    std::vector<float> output(const std::vector<float>& inputs, unsigned layer);
    std::vector<float> output(const std::vector<float>& inputs)
    { return output(inputs, _layers.size());}
    std::vector<float> outputlag(const std::vector<float>& inputs, unsigned lag);

    virtual void	display() const;

    // Dump the network to file
    virtual void	outputFile(const std::string file) const;
    // Load a neural net description file
    virtual void	inputFile(const std::string file);

  protected:
    // Initialization
    void	_init_variables();
    void	_init_network(const std::vector<unsigned>& nb,
			      const std::vector<unsigned>& winsize,
			      ActivationFunctionType type,
			      ActivationFunctionType typeOut);
    void	_init_connections();

    // Backprop Stuffs
    float	_train(const NNdata_t& inputs, bool batch, 
		       TrainingAlgorithm algo);
    float	_backwardsPass(const std::vector<float>& res,
			       bool batch,
			       TrainingAlgorithm algo);

    // Update the weigths
    void	_updateWeights(TrainingAlgorithm algorithm, float err, float lastErr);

    void	_clear(int flags)
    {
      for (unsigned int l = 0; l < _layers.size(); l++)
	for (unsigned int n = 0; n < _layers[l].size(); n++)
	  {
	    Neuron *neuron = (_layers[l])[n];
	    neuron->clearset(flags, _wdecay, _tri0);
	  }
    }

  private:
    void	split(const std::string& s,
		      std::vector<std::string>& v,
		      unsigned char sep);

  protected:

    std::vector<TimeLaggedInputNeuron* > _inputlayer;
    std::vector<unsigned>			_winsize;
  };

}// ! namespace NeuralNet

#endif	    /* !TIMELAGGEDNETWORK_HH_ */
