/*
 * Definitions for libesedb
 *
 * Copyright (C) 2009-2015, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBESEDB_DEFINITIONS_H )
#define _LIBESEDB_DEFINITIONS_H

#include <libesedb/types.h>

#define LIBESEDB_VERSION						20150409

/* The version string
 */
#define LIBESEDB_VERSION_STRING						"20150409"

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBESEDB_ACCESS_FLAGS
{
	LIBESEDB_ACCESS_FLAG_READ					= 0x01,
/* Reserved: not supported yet */
	LIBESEDB_ACCESS_FLAG_WRITE					= 0x02
};

/* The file access macros
 */
#define LIBESEDB_OPEN_READ						( LIBESEDB_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBESEDB_OPEN_WRITE						( LIBESEDB_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBESEDB_OPEN_READ_WRITE					( LIBESEDB_ACCESS_FLAG_READ | LIBESEDB_ACCESS_FLAG_WRITE )

/* TODO deprecated remove after a while */
#define LIBESEDB_FLAG_READ						LIBESEDB_ACCESS_FLAG_READ
#define LIBESEDB_FLAG_WRITE						LIBESEDB_ACCESS_FLAG_WRITE

/* The file types
 */
enum LIBESEDB_FILE_TYPES
{
	LIBESEDB_FILE_TYPE_DATABASE					= 0,
	LIBESEDB_FILE_TYPE_STREAMING_FILE				= 1
};

/* The get columns flags
 */
enum LIBESEDB_GET_COLUMN_FLAGS
{
	LIBESEDB_GET_COLUMN_FLAG_IGNORE_TEMPLATE_TABLE			= 0x01
};

/* The column types
 */
enum LIBESEDB_COLUMN_TYPES
{
	LIBESEDB_COLUMN_TYPE_NULL					= 0,
	LIBESEDB_COLUMN_TYPE_BOOLEAN					= 1,
	LIBESEDB_COLUMN_TYPE_INTEGER_8BIT_UNSIGNED			= 2,
	LIBESEDB_COLUMN_TYPE_INTEGER_16BIT_SIGNED			= 3,
	LIBESEDB_COLUMN_TYPE_INTEGER_32BIT_SIGNED			= 4,
	LIBESEDB_COLUMN_TYPE_CURRENCY					= 5,
	LIBESEDB_COLUMN_TYPE_FLOAT_32BIT				= 6,
	LIBESEDB_COLUMN_TYPE_DOUBLE_64BIT				= 7,
	LIBESEDB_COLUMN_TYPE_DATE_TIME					= 8,
	LIBESEDB_COLUMN_TYPE_BINARY_DATA				= 9,
	LIBESEDB_COLUMN_TYPE_TEXT					= 10,
	LIBESEDB_COLUMN_TYPE_LARGE_BINARY_DATA				= 11,
	LIBESEDB_COLUMN_TYPE_LARGE_TEXT					= 12,
	LIBESEDB_COLUMN_TYPE_SUPER_LARGE_VALUE				= 13,
	LIBESEDB_COLUMN_TYPE_INTEGER_32BIT_UNSIGNED			= 14,
	LIBESEDB_COLUMN_TYPE_INTEGER_64BIT_SIGNED			= 15,
	LIBESEDB_COLUMN_TYPE_GUID					= 16,
	LIBESEDB_COLUMN_TYPE_INTEGER_16BIT_UNSIGNED			= 17
};

/* The value flags
 */
enum LIBESEDB_VALUE_FLAGS
{
	LIBESEDB_VALUE_FLAG_VARIABLE_SIZE				= 0x01,
	LIBESEDB_VALUE_FLAG_COMPRESSED					= 0x02,
	LIBESEDB_VALUE_FLAG_LONG_VALUE					= 0x04,
	LIBESEDB_VALUE_FLAG_MULTI_VALUE					= 0x08,
};

#endif

