/*
 * $Id: pbm.h,v 1.13 2007/06/02 19:55:22 simakov Exp $
 *
 * EPSILON - wavelet image compression library.
 * Copyright (C) 2006-2007 Alexander Simakov, <xander@entropyware.info>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://epsilon-project.sourceforge.net
 */

#ifndef __PBM_H__
#define __PBM_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

/* PBM file type */
#define PBM_TYPE_PGM            0
#define PBM_TYPE_PPM            1

/* Return codes */
#define PBM_OK                  0
#define PBM_FORMAT_ERROR        1
#define PBM_SYSTEM_ERROR        2
#define PBM_PARAM_ERROR         3

/* PBM file context */
typedef struct pbm_image_tag {
    int type;
    int width;
    int height;
    int max_val;
    FILE *f;
    off_t hdr_size;
    off_t data_size;
} pbm_image;

int get_file_size(char *pathname, off_t *file_size);
static int fseeko_jumbo(FILE *f, off_t offset, int whence);
static int get_char(FILE *f);
static int get_integer(FILE *f, int *val);
int pbm_open(char *pathname, pbm_image *pbm);
int pbm_create(char *pathname, pbm_image *pbm);
void pbm_close(pbm_image *pbm);
int pbm_read_pgm(pbm_image *pbm, unsigned char **block,
                 int x, int y, int width, int height);
int pbm_write_pgm(pbm_image *pbm, unsigned char **block,
                  int x, int y, int width, int height);
int pbm_read_ppm(pbm_image *pbm, unsigned char **block_R,
                 unsigned char **block_G, unsigned char **block_B,
                 int x, int y, int width, int height);
int pbm_write_ppm(pbm_image *pbm, unsigned char **block_R,
                  unsigned char **block_G, unsigned char **block_B,
                  int x, int y, int width, int height);

#ifdef __cplusplus
}
#endif

#endif /* __PBM_H__ */
