#include "wsint.h"

G_DEFINE_TYPE (WsRegion, ws_region, WS_TYPE_RESOURCE);

static void
ws_region_finalize (GObject *object)
{
    WsRegion *region = WS_REGION (object);
    
    XFixesDestroyRegion (WS_RESOURCE_XDISPLAY (region),
			 WS_RESOURCE_XID (region));

    G_OBJECT_CLASS (ws_region_parent_class)->finalize (object);
}

static void
ws_region_class_init (WsRegionClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    object_class->finalize = ws_region_finalize;
}

static void
ws_region_init (WsRegion *region)
{

}

WsRegion *
ws_region_new (WsDisplay *display)
{
    XID xregion = XFixesCreateRegion (display->xdisplay, NULL, 0);

    WsRegion *region = g_object_new (WS_TYPE_REGION,
				     "display", display,
				     "xid", xregion,
				     NULL);
    
    return region;
}

void
ws_region_union (WsRegion *region,
		 WsRegion *other)
{
    XFixesUnionRegion (WS_RESOURCE_XDISPLAY (region),
		       WS_RESOURCE_XID (region),
		       WS_RESOURCE_XID (region),
		       WS_RESOURCE_XID (other));
}

WsRectangle *
ws_region_query_rectangles (WsRegion *region,
			    guint    *n_rectangles)
{
    int n_rects = 0;
    XRectangle *xrects;
    
    xrects = XFixesFetchRegion (WS_RESOURCE_XDISPLAY (region),
			       WS_RESOURCE_XID (region), &n_rects);

    if (n_rectangles)
	*n_rectangles = n_rects;
	
    if (xrects)
    {
	WsRectangle *ws_rects = g_new (WsRectangle, n_rects);
	int i;

	for (i = 0; i < n_rects; ++i)
	{
	    ws_rects[i].x = xrects[i].x;
	    ws_rects[i].y = xrects[i].y;
	    ws_rects[i].width = xrects[i].width;
	    ws_rects[i].height = xrects[i].height;
	}

	return ws_rects;
    }

    return NULL;
}
