/***************************************************************************
 $RCSfile: tagfile.h,v $
 -------------------
 cvs         : $Id: tagfile.h,v 1.2 2003/02/09 01:59:29 aquamaniac Exp $
 begin       : Sat Feb 08 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@libchipcard.de

 ****************************************************************************
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 ****************************************************************************/


#ifndef TAGFILE_H
#define TAGFILE_H

#include <stdio.h>
#include <string>
#include <list>


/**
 * This class allows reading and writing of files consisting of so called
 * "tags". A tag looks like this:
 * <ul>
 *   <li>2 bytes tag type identifier</li>
 *   <li>4 bytes length of the tag's data</li>
 *   <li>x bytes tag data</li>
 * </ul>
 */
class TagFile {
public:
  /**
   *
   */
  class Tag {
  private:
    int _type;
    unsigned long _length;
    unsigned long _offset;
    string _data;
  public:
    Tag(const string &t, unsigned long o);
    Tag(int t, unsigned long l, unsigned long o, const string &data="");
    Tag();
    ~Tag();
    int type() const { return _type;};
    unsigned long length() const { return _length;};
    unsigned long offset() const { return _offset;};
    void setOffset(unsigned long o) { _offset=o;};
    unsigned long dataOffset() const { return _offset+6;};
    const string &data() const { return _data;};
    string toString() const;
  };

private:
  list<Tag> _tags;
  string _filename;
  FILE *_file;
  unsigned long _nextTag;
  unsigned long _filesize;

public:
  TagFile();
  TagFile(const string &filename);

  bool openFile();
  bool createFile();
  bool closeFile();

  /**
   * Reads all tag headers from the file (without their data!)
   */
  bool scanFile();

  /**
   * Writes all tags to the file but not their data !
   * This allows to write the data later.
   */
  bool formatFile();

  list<Tag> &tagList();
  void addTag(Tag &t);

  string readTagData(const Tag &t,
		     unsigned long pos,
		     unsigned long len);
  bool writeTagData(const Tag &t,
		    unsigned long pos,
		    const string &data);

};



#endif


