<?

    // Linux CPU Graph, UCD-SNMP 
    // By Robert Bogdon 

    function graph_ucd_cpu_linux ($data) { 

	$limit = $data["cpu_num"]*100;
	
	$opts_DEF = rrdtool_get_def($data,array("cpu_user_ticks","cpu_idle_ticks","cpu_nice_ticks","cpu_system_ticks"));
         
        $opts_GRAPH = array(   
    		"HRULE:$limit#990000:'Number of Processors\: ".$data["cpu_num"]."\\n'",

    	        "AREA:cpu_user_ticks#FF0000:'User   CPU Time'", 
                "GPRINT:cpu_user_ticks:MAX:'Max\:%8.2lf %%'", 
                "GPRINT:cpu_user_ticks:AVERAGE:'Average\:%8.2lf %%'", 
                "GPRINT:cpu_user_ticks:LAST:'Last\:%8.2lf %%\\n'", 

                "STACK:cpu_nice_ticks#0000FF:'Nice   CPU Time'", 
                "GPRINT:cpu_nice_ticks:MAX:'Max\:%8.2lf %%'", 
                "GPRINT:cpu_nice_ticks:AVERAGE:'Average\:%8.2lf %%'", 
                "GPRINT:cpu_nice_ticks:LAST:'Last\:%8.2lf %%\\n'", 

                "STACK:cpu_system_ticks#FFFF00:'System CPU Time'", 
                "GPRINT:cpu_system_ticks:MAX:'Max\:%8.2lf %%'", 
                "GPRINT:cpu_system_ticks:AVERAGE:'Average\:%8.2lf %%'", 
                "GPRINT:cpu_system_ticks:LAST:'Last\:%8.2lf %%\\n'", 
                
                "STACK:cpu_idle_ticks#00CC00:'Idle   CPU Time'", 
                "GPRINT:cpu_idle_ticks:MAX:'Max\:%8.2lf %%'", 
                "GPRINT:cpu_idle_ticks:AVERAGE:'Average\:%8.2lf %%'", 
    		"GPRINT:cpu_idle_ticks:LAST:'Last\:%8.2lf %%\\n'"); 
		
		
	$opts_header[] = "--vertical-label='CPU Usage'"; 
	$opts_header[] = "--rigid";
	$opts_header[] = "--upper-limit=$limit";

        return array ($opts_header, array_merge($opts_DEF,$opts_GRAPH));     
    } 
?> 
