/*  Copyright (C) 2012 JabRef contributors.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

package net.sf.jabref.imports;

/**
 * Container class for lists with keywords where the case should be kept independent of bibstyle
 * 
 */
public class CaseKeeperList {
   
    // Common words in IEEE Xplore that should always be in the given case
   public String[] wordListIEEEXplore = new String[]{
        "1-D",
        "1D",
        "2-D",
        "2D",
        "3-D",
        "3D",
        "3G",
        "4G",
        "A/D",
	"ACM",
        "AC",
        "ADC",
        "ADI",
	"ADSL",
        "AES",
        "ALU",
        "AMPS",
        "AM",
        "ANOVA",
        "ANSI",
        "API",
        "ARQ",
        "ASIC",
	"ATM",
        "AVC",
        "AlGaAs",
        "Altera",
        "BCD",
        "BCH",
        "BER",
        "BIST",
        "BJT",
        "BPSK",
        "Bayes",
        "Bessel",
        "BiCMOS",
        "Bluetooth",
        "Bragg",
        "Butterworth",
        "CAD",
        "CATV",
        "CBR",
        "CDMA",
        "CDR",
        "CIC",
        "CMOS",
        "CMRR",
        "CNN",
	"CORDIC",
        "CPLD",
        "CPU",
        "CRC",
        "CSD",
        "CSIT",
        "CSI",
        "CSMA",
        "Carlo",
        "Cauer",
        "Chebyshev",
        "D/A",
        "DAB",
	"DAC",
	"DCT",
        "DC",
        "DDFS",
        "DDR",
        "DDSM",
        "DDS",
        "DEM",
        "DFE",
        "DFT",
        "DLL",
	"DMT",
        "DNL",
        "DOCSIS",
        "DRAM",
        "DRM",
        "DSP",
	"DST",
        "DVB-C",
        "DVB-H",
        "DVB-S",
        "DVB-T",
        "DVB",
        "DVFS",
        "DVI",
        "DWT",
        "ECG",
        "ECL",
        "EDGE",
        "EEG",
        "EMC",
        "EMG",
        "EMI",
        "ENOB",
        "EPROM",
        "EVM",
        "FDTD",
        "FEM",
        "FER",
        "FET",
        "FFT",
        "FIFO",
	"FIR",
        "FMCW",
	"FM",
        "FPGA",
        "FPU",
        "FRM",
	"Farrow",
        "Fourier",
        "GALS",
        "GHz",
        "GIS",
        "GNSS",
        "GNU",
        "GPGPU",
        "GPRS",
        "GPS",
        "GPU",
        "GSM",
        "GSPS",
        "GS",
        "GaAs",
        "Galileo",
        "Gauss",
        "Gb",
        "H.264",
        "HARQ",
        "HBT",
        "HDMI",
        "HDTV",
        "HD",
        "HEMT",
        "HEVC",
        "HMM",
        "Haar",
        "Hadamard",
        "Hamming",
        "Hilbert",
        "I/O",
        "I/Q",
        "IBM",
        "ICA",
        "IC",
        "IDCT",
        "IDFT",
        "IEEE",
        "IFFT",
        "IFIR",
        "IF",
        "IGBT",
        "IIR",
        "ILP",
        "INL",
        "IO",
        "IPTV",
        "IP",
        "IQ",
        "ISDN",
        "ISI",
        "ISM",
        "InP",
        "JFET",
        "JPEG",
        "JTAG",
        "Kalman",
        "Karatsuba",
        "LAN",
        "LCD",
        "LDA",
        "LDD",
        "LDI",
        "QC-LDPC",  // until sorting on length works
        "LDPC",
        "LED",
        "LFSR",
        "LNA",
        "LNS",
        "LSB",
        "LTE-A",
        "LTE",
        "LTI",
        "LVDC",
        "LVDS",
        "Laplace",
        "MAC",
        "MANET",
        "MAP",
        "MASH",
        "MCM",
        "MCU",
        "MEMS",
        "MESFET",
        "MHz",
        "MILP",
        "MIMO",
        "MISO",
        "MMIC",
        "MMSE",
        "MOSFET",
        "MOS",
        "MPEG",
        "MPSoC",
        "MRI",
        "MSB",
        "MSD",
        "MSPS",
        "MS",
        "MTCMOS",
        "Markov",
        "Maxwell",
        "Mb",
        "Miller",
        "Monte",
        "Msps",
        "NMOS",
        "NTSC",
        "Newton",
        "NoC",
        "Nyquist",
        "OFDMA",
        "OFDM",
        "OSR",
        "OTA-C",
        "OTA",
        "P2P",
        "PAL",
        "PAM",
        "PAPR",
        "PCA",
        "PCI",
        "PCM",
        "PC",
        "PHY",
        "PID",
        "PLC",
        "PLL",
        "PMOS",
        "POTS",
        "PSRR",
        "PWM",
        "PowerPC",
        "QAM",
        "QPSK",
        "QRD",
        "QoS",
        "RAD",
        "RAM",
        "RCS",
        "RFDAC",
        "RFE",
        "RFID",
        "RF",
        "RISC",
        "RLS",
        "RMS",
        "RNS",
        "ROM",
        "RSA",
        "RTOS",
        "Reed",
        "Remez",
        "SAR",
        "SAW",
        "SC",
        "SDF",
        "SDH",
        "SDRAM",
        "SDR",
        "SFDR",
        "SIMO",
        "SINAD",
        "SINR",
        "SISO",
        "SNDR",
        "SNR",
        "SOI",
        "SONET",
        "SPT",
        "SRAM",
        "SQNR",
        "SVD",
        "SVM",
        "SerDes",
        "Shannon",
        "SiGe",
        "SoC",
        "Solomon",
        "SystemC",
        "TCP",
        "TDMA",
        "TETRA",
        "TFT",
        "THD",
        "TSPC",
        "TV",
        "UAV",
        "UHF",
        "UMTS",
        "USRP",
        "UWB",
        "VBR",
        "VCO",
        "VDD",
        "VDSL",
        "VGA",
        "VHDL",
        "VHF",
        "VLIW",
        "VLSI",
        "VOD",
        "VQ",
        "VSB",
        "Vdd",
        "Verilog-AMS",
        "Verilog-A",
        "Verilog",
        "Viterbi",
        "VoD",
        "VoIP",
        "Volterra",
        "WCDMA",
        "WDF",
        "WLAN",
        "WPAN",
        "WWW",
        "Watt",
        "WiMAX",
        "Winograd",
        "XML",
        "Xilinx",
        "ZigBee",
        "dB",
        "kHz",
        "kS",
        "mW",
        "xDSL"
   };
    
   
   // List of all keyword lists
   private String[][] allLists = new String[][] {
       wordListIEEEXplore
   };
   
   public CaseKeeperList () {
   
   };
   /* Return all lists concatenated
    * Can be done faster once deciding on Java 6.0
    * see: http://stackoverflow.com/questions/80476/how-to-concatenate-two-arrays-in-java
    */
    public String[] getAll() {
        int lengh = 0;
        for (String[] array : allLists) {
            lengh += array.length;
        }
        String[] result = new String[lengh];
        int pos = 0;
        for (String[] array : allLists) {
            for (String element : array) {
                result[pos] = element;
                pos++;
            }
        }
        return result;
    }
}
