#****************************************************************************
#*                              IviProc.tcl
#*
#* Author: Matthew Ballance
#* Desc:
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************


namespace eval IviProc {
    variable        d_procCount 0
    variable        d_msgBuf    ""

}

#********************************************************************
#* MsgCB
#********************************************************************
proc IviProc::MsgCB {ch} {
    variable d_msgBuf

    set tmp [read $ch]

    set d_msgBuf "${d_msgBuf}${tmp}"

    set idx 0

    while {$idx >= 0} {
        set idx [string first "\n" $d_msgBuf]

        if {$idx < 0} {
            break
        }

        set msg [string range $d_msgBuf 0 [expr $idx - 1]]
        set d_msgBuf [string range $d_msgBuf \
            [expr $idx + 1] end]
        ivi_puts "$msg"
    }
}

#********************************************************************
#* ivi_exec
#********************************************************************
proc IviProc::ivi_exec {arg_list} {

    variable d_procCount

    incr d_procCount

    set pname "ivi_proc${d_procCount}"
    ivi_proc $pname

    $pname set_option merge_std true

#    set ch "${pname}.stdout"

    $pname set_invoke $arg_list
    $pname invoke

    set ch [$pname get_stdout]

    fconfigure $ch -buffering none
    fileevent $ch readable [list IviProc::MsgCB $ch]

    set result [$pname wait]

    $pname destroy

    return ""

    return $result
}

