########################################################################################################
## WARNING!! BAD ENGLISH BELOW :P
##
## This script is designed for those who have been using muh irc bouncer.
## Basicly this script just monitors the proxy module and if new client
## connects it sets you automatically back from away state and when client
## disconnects it sets you automatically away if you arent allready away.
##
## Other hand if you dont use irssi-proxy you still have a good reason to
## use this if you want to forward messages that come to you while
## you are away to email box.
## This is usefull for forwarding messages to an SMS-gateway ;) 
##
## btw.. if you find any bugs or have any ideas for development of this
## script dont hesitate to send msg to BCOW@IrcNET
## or send email to anttip@n0-life.com
##
#### Version history:
# 0.1
#  * basic functionality
# 0.2b
#  * a patch from Wulf that gives a user ability to change the autoaway reason.
#  * Added away_level parameter that gives you ability to control how many clients
#    there can be connected to the irssi_proxy module before you are set away.
#  * You arent set away when disconnecting from the irssi_proxy if you allready are away.
#    This means that your current away reason isent changed.
#  * Sends cumulated away messages back to the client when it connects to the irssi_proxy module.
#### To come / planned:
########################################################################################################

# irssi imports
use Irssi;
use Irssi::Irc;
use vars qw($VERSION %IRSSI);

$VERSION = "0.2b";
%IRSSI = (
 authors => "BCOW",
 contact => "anttip\@n0-life.com",
 name => "awayproxy",
 description => "Sets nick away when client discconects from the irssi-proxy. If away gathers messages targeted to nick and forwards them to an email address.",
 license => "GPLv2",
 url => "http://www.n0-life.com",
);

# setting that is used to control the timeout loop that checks that
# do we need to send the messages forward.
Irssi::settings_add_int('awayproxy', 'check_interval', '30');
#Irssi::settings_add_int('awayproxy', 'check_interval', 30);
# this setting controls that when this amout of clients are connected to the proxy module
# script sets you away. IF you set this to 0 you are set away when no clients are connected to the
# proxy module. If you set this to lets say 5 then you will be set away allways when the amount
# of clients connected to the proxy module is 5 or under.
Irssi::settings_add_int('awayproxy', 'away_level', '0');
# email address where to send the email
Irssi::settings_add_str('awayproxy', 'emailto', 'receiver@somewhere.fi');
# sendmail programs location
Irssi::settings_add_str('awayproxy', 'sendmail', '/usr/sbin/sendmail');
# who is the sender of the email
Irssi::settings_add_str('awayproxy', 'emailfrom', 'sender@somewhere.org');
# and the awayreason setting (Thanx Wulf)
Irssi::settings_add_str('awayproxy', 'awayreason', 'autoaway because client disconnected from proxy module');

# number of clients connected
my $clientcount = 0;
# the small list
my @awaymsglist;
my $awaymsglistnum = -1;
# the archive list
my @awaymsglist2;
my $awaymsglist2num = -1;
# timeouts for check loop
my $timeout = Irssi::settings_get_int("check_interval");
my $timeouttag = Irssi::timeout_add($timeout*1000, 'msgsend_check', '');

sub msgsend_check {
 #Irssi::print("Viestej olis niinku lhdss $awaymsglistnum kpl :P");
 my $texti;
 if ($awaymsglistnum > -1) {
  for (my $i = 0; $i <= $awaymsglistnum; $i++) {
   $texti = "$texti$awaymsglist[$i]\n";
  }
  $awaymsglistnum = -1;
  my $emailto = Irssi::settings_get_str("emailto");
  my $emailfrom = Irssi::settings_get_str("emailfrom");
  my $sendmail = Irssi::settings_get_str("sendmail");
  &send_mail($texti, $sendmail, $emailto, $emailfrom);
 }
}

sub client_connect {
 my (@servers) = Irssi::servers;
 my $mynick = "";
 
 $clientcount++;
 #Irssi::print("awayproxy.pl::client_connect()");

 # setback
 foreach $server (@servers) {
  $server->send_raw("AWAY :");
  my $mynick = $server->{nick};
  # and then send the current contents of archive list as notify's to your self ;)
  # .. weird huh? :)
  # This sends all the away messages to ALL the servers where you are connected... this is somewhat weird i know
  # but if someone wants to make a patch to this i would really appreciate it.
  foreach $message (@awaymsglist2) {
   $server->send_raw("NOTICE $mynick :$message");
  }
 }
 # and "clear" the awaymessage list
 $awaymsglist2num = -1;
}

sub client_disconnect {
 my (@servers) = Irssi::servers;
 #Irssi::print("awayproxy.pl::client_disconnect()");

 $clientcount--;
 if ($clientcount < 0) { $clientcount = 0; }

 # setaway
 my $awaylevel = Irssi::settings_get_str("away_level");
 my $awayreason = Irssi::settings_get_str("awayreason");
 if ($clientcount <= $awaylevel) {
  # ok.. we have the away_level of clients connected or less.
  foreach $server (@servers) {
   if ($server->{usermode_away} == "0") {
    # we are not away on this server allready.. set the autoaway reason
    $server->send_raw("AWAY :$awayreason");
   }
  }
 }
}

sub msg_pub {
 my ($server, $data, $nick, $mask, $target) = @_;
 
 #Irssi::print("$server->{nick}");

 if ($server->{usermode_away} == "1" && $data=~/$server->{nick}/i) {
  # simple list that is emptied on the email run
  $awaymsglistnum++;
  $awaymsglist[$awaymsglistnum] = "<$nick!$mask\@$target> $data";
  # archive list that is emptied only on the client connect run
  $awaymsglist2num++;
  $awaymshlist2[$awaymsglist2num] = "<$nick!$mask\@$target> $data";
 }
}

sub msg_pri {
 my ($server, $data, $nick, $address) = @_;
 if ($server->{usermode_away} == "1") {
  # simple list that is emptied on the email run
  $awaymsglistnum++;
  $awaymsglist[$awaymsglistnum] = "<$nick!$address> $data";
  # archive list that is emptied only on the client connect run
  $awaymsglist2num++;
  $awaymshlist2[$awaymsglist2num] = "<$nick!$address> $data";
 }
}

sub send_mail {
 my ($text, $sendmail, $email, $from) = @_;
 open (MAIL, "|$sendmail -t");
 print MAIL "To: $email\n";
 print MAIL "From: $from\n";
 print MAIL "$text";
 close (MAIL);
}

Irssi::signal_add_last('proxy client connected','client_connect');
Irssi::signal_add_last('proxy client disconnected','client_disconnect');
Irssi::signal_add_last('message public','msg_pub');
Irssi::signal_add_last('message private','msg_pri');