%define letool %{_bindir}/iiimf-le-tools
%define sendhup /usr/bin/killall -HUP htt_server >& /dev/null || :
%define instle %{letool} --install %{im_dir}/leif/
%define uninstle %{letool} --remove %{im_dir}/leif/

Summary: An IIIMF Language Engine for Traditional Chinese.
Name: iiimf-le-xcin
Version: 0.1.8
Release: 1
License: GPL
Group: User Interface/X
Source0: %{name}-%{version}.tar.bz2
Patch1:  iiimf-le-xcin_01_so.diff
Patch2:  iiimf-le-xcin_02_new_path.diff
URL: http://tciiimf.sourceforge.net/

BuildRequires: automake, libtool, libxml2-devel
Requires: iiimf-server >= 11.4-4
Buildroot: %{_tmppath}/%{name}-buildroot

%description
A IIIMF language engine which ported from a popular traditional chinese input method, xcin, which was written using XIM protocol

%prep

rm -rf $RPM_BUILD_ROOT

%setup -q
%patch1 -p1
%patch2 -p1

%build
aclocal -I ./acfiles $ACLOCAL_FLAGS
libtoolize --force --copy
autoheader
automake -a -c -f
autoconf
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
make

%install

mkdir -p $RPM_BUILD_ROOT/usr/lib/iiim/le/xcin/tab
make install DESTDIR=$RPM_BUILD_ROOT

%post
if [ -x %{letool} ]; then
  %{instle}xcin.so --default >& /dev/null || :
  %{sendhup}
fi

%preun
if [ "$1" = 0 ]; then
  if [ -x %{letool} ]; then
    %{uninstle}xcin.so >& /dev/null || :
    %{sendhup}
  fi
fi

%files
%defattr(-,root,root)
%dir /usr/lib/iiim/le/xcin/
%dir /usr/lib/iiim/le/xcin/tab/
%doc README ChangeLog 
%config /usr/lib/iiim/le/xcin/xcin.xml.conf
/usr/lib/iiim/le/xcin/*


%clean 
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%changelog
* Tue Aug 17 2004 Leon Ho <llch@redhat.com> 0.1.7-2
- add buildrequires on libxml2-devel, automake16 and libtool

* Mon Aug 16 2004 Leon Ho <llch@redhat.com> 0.1.7-1
- add xmlconf for tab files
- fixes more dynamic memory
- commented out source table for tab files
- added utf8 to utf16 function
- use cname in tab file if not specify in xml
- added new makefile.am and configure.ac for new xml and xml.conf

* Wed Aug 04 2004 Leon Ho <llch@redhat.com> 0.1-5-5
- backport from cvs
    - fixed non-reg key hold up problem (#127812)
    - added gen_inp_xim_end() and more free()s to resolve memory
    - resolved loadtab()'s malloc didn't free prob
    - added the call of gen_inp_xim_end() at DestorySC()
    - added arrow keys for changing candidate pages
    - added endkey feature which will lock in for the candidate
    - added check keyname so that it won't lock in if numeric
    - tidy up lookup_draw()

* Tue Jun 22 2004 Leon Ho <llch@redhat.com> 0.1-5-4
- backport from cvs
    - fixed no status window on conversion off
    - tidy up and seperate out sources
    - fix up some of the minor codings

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri May 21 2004 Leon Ho <llch@redhat.com> 0.1-5-2
- backport from cvs
    - fixed the problem on ctrl, alt keys when turned on (#121050)
    - added new candidate selection screen (shift+< and shift+>)

* Thu Apr 15 2004 Leon Ho <llch@redhat.com> 0.1.5-1
- iiimf-xcin 0.1.5
    - Included nine input methods
    - Use keyname instead of normal letters in preedit area
    - Fixed 'enter' should commit candidate when lookup is on
    - Fixed crash problem on running le couple of times
    - Fixed crash problem on loading input styles couple of times
    - Added ctrl-shift switching
    - Fixed the lookup window by closing it when switching

* Fri Feb 27 2004 Leon Ho <llch@redhat.com> 0.1-5
- rebuilt

* Thu Feb 26 2004 Leon Ho <llch@redhat.com> 0.1-4
- install cin2tab with 755 (#116892)
- install .so files with executable (#116554)
- fixed '0' commit to preedit problem
- added 'esc' clean preedit
- fixed candidates non-empty problems

* Thu Feb 16 2004 Leon Ho <llch@redhat.com> 0.1-3
- added cin2tab
- added conversion of cin to tab in compilation time

* Thu Feb 12 2004 Leon Ho <llch@redhat.com> 0.1-2
- fixed some multi candidates problem
- add tab file and change tab file locations

* Wed Feb 11 2004 Leon Ho <llch@redhat.com> 0.1-1
- iiimf-xcin v0.1

