/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif
#include <limits.h>
#include <ctype.h>
#include <sys/errno.h>
extern int errno;

#include "unit_input.h"
#include "xaux_locale.h"
#include "encode.h"
#include "logf.h"

#define COMMENT '#'

extern char lename_string[];
extern UTFCHAR lename_utf_string[];
IMLEName leName = {lename_string, lename_utf_string };
IMLocale loc[MAX_SUPPORTED_LOCALES];
int numLocales = 0;

extern int CpyUTFCHAR(char *, UTFCHAR *);

keyvalue_pair kvp[] = {
	{(char *)"IM_SHIFT_MASK", 1},
	{(char *)"IM_CTRL_MASK", 2},
	{(char *)"IM_META_MASK", 4},
	{(char *)"IM_ALT_MASK", 8},
	{(char *)"IM_ALT_GRAPH_MASK", 32},
	{(char *)"IM_BUTTON1_MASK", 16},
	{(char *)"IM_VK_CANCEL", 	3},
	{(char *)"IM_VK_CLEAR", 	12},
	{(char *)"IM_VK_SHIFT", 	16},
	{(char *)"IM_VK_CONTROL", 	17},
	{(char *)"IM_VK_ALT", 	18},
	{(char *)"IM_VK_PAUSE", 	19},
	{(char *)"IM_VK_CAPS_LOCK", 	20},
	{(char *)"IM_VK_ESCAPE", 	27},
	{(char *)"IM_VK_SPACE", 	32},
	{(char *)"IM_VK_PAGE_UP", 	33},
	{(char *)"IM_VK_PAGE_DOWN", 	34},
	{(char *)"IM_VK_END", 	35},
	{(char *)"IM_VK_HOME", 	36},
	{(char *)"IM_VK_LEFT", 	37},
	{(char *)"IM_VK_UP", 	38},
	{(char *)"IM_VK_RIGHT", 	39},
	{(char *)"IM_VK_DOWN", 	40},
	{(char *)"IM_VK_COMMA", 	44},
	{(char *)"IM_VK_MINUS", 	45},
	{(char *)"IM_VK_PERIOD", 	46},
	{(char *)"IM_VK_SLASH", 	47},
	{(char *)"IM_VK_0", 	48},
	{(char *)"IM_VK_1", 	49},
	{(char *)"IM_VK_2", 	50},
	{(char *)"IM_VK_3", 	51},
	{(char *)"IM_VK_4", 	52},
	{(char *)"IM_VK_5", 	53},
	{(char *)"IM_VK_6", 	54},
	{(char *)"IM_VK_7", 	55},
	{(char *)"IM_VK_8", 	56},
	{(char *)"IM_VK_9", 	57},
	{(char *)"IM_VK_SEMICOLON", 	59},
	{(char *)"IM_VK_EQUALS", 	61},
	{(char *)"IM_VK_A", 	65},
	{(char *)"IM_VK_B", 	66},
	{(char *)"IM_VK_C", 	67},
	{(char *)"IM_VK_D", 	68},
	{(char *)"IM_VK_E", 	69},
	{(char *)"IM_VK_F", 	70},
	{(char *)"IM_VK_G", 	71},
	{(char *)"IM_VK_H", 	72},
	{(char *)"IM_VK_I", 	73},
	{(char *)"IM_VK_J", 	74},
	{(char *)"IM_VK_K", 	75},
	{(char *)"IM_VK_L", 	76},
	{(char *)"IM_VK_M", 	77},
	{(char *)"IM_VK_N", 	78},
	{(char *)"IM_VK_O", 	79},
	{(char *)"IM_VK_P", 	80},
	{(char *)"IM_VK_Q", 	81},
	{(char *)"IM_VK_R", 	82},
	{(char *)"IM_VK_S", 	83},
	{(char *)"IM_VK_T", 	84},
	{(char *)"IM_VK_U", 	85},
	{(char *)"IM_VK_V", 	86},
	{(char *)"IM_VK_W", 	87},
	{(char *)"IM_VK_X", 	88},
	{(char *)"IM_VK_Y", 	89},
	{(char *)"IM_VK_Z", 	90},
	{(char *)"IM_VK_OPEN_BRACKET", 	91},
	{(char *)"IM_VK_BACK_SLASH", 	92},
	{(char *)"IM_VK_CLOSE_BRACKET", 	93},
	{(char *)"IM_VK_NUMPAD0", 	96},
	{(char *)"IM_VK_NUMPAD1", 	97},
	{(char *)"IM_VK_NUMPAD2", 	98},
	{(char *)"IM_VK_NUMPAD3", 	99},
	{(char *)"IM_VK_NUMPAD4", 	100},
	{(char *)"IM_VK_NUMPAD5", 	101},
	{(char *)"IM_VK_NUMPAD6", 	102},
	{(char *)"IM_VK_NUMPAD7", 	103},
	{(char *)"IM_VK_NUMPAD8", 	104},
	{(char *)"IM_VK_NUMPAD9", 	105},
	{(char *)"IM_VK_MULTIPLY", 	106},
	{(char *)"IM_VK_ADD", 	107},
	{(char *)"IM_VK_SEPARATER", 	108},
	{(char *)"IM_VK_SUBTRACT", 	109},
	{(char *)"IM_VK_DECIMAL", 	110},
	{(char *)"IM_VK_DIVIDE", 	111},
	{(char *)"IM_VK_DELETE", 	127},
	{(char *)"IM_VK_NUM_LOCK", 	144},
	{(char *)"IM_VK_SCROLL_LOCK", 	145},
	{(char *)"IM_VK_F1", 	112},
	{(char *)"IM_VK_F2", 	113},
	{(char *)"IM_VK_F3", 	114},
	{(char *)"IM_VK_F4", 	115},
	{(char *)"IM_VK_F5", 	116},
	{(char *)"IM_VK_F6", 	117},
	{(char *)"IM_VK_F7", 	118},
	{(char *)"IM_VK_F8", 	119},
	{(char *)"IM_VK_F9", 	120},
	{(char *)"IM_VK_F10", 	121},
	{(char *)"IM_VK_F11", 	122},
	{(char *)"IM_VK_F12", 	123},
	{(char *)"IM_VK_F13", 	61440},
	{(char *)"IM_VK_F14", 	61441},
	{(char *)"IM_VK_F15", 	61442},
	{(char *)"IM_VK_F16", 	61443},
	{(char *)"IM_VK_F17", 	61444},
	{(char *)"IM_VK_F18", 	61445},
	{(char *)"IM_VK_F19", 	61446},
	{(char *)"IM_VK_F20", 	61447},
	{(char *)"IM_VK_F21", 	61448},
	{(char *)"IM_VK_F22", 	61449},
	{(char *)"IM_VK_F23", 	61450},
	{(char *)"IM_VK_F24", 	61451},
	{(char *)"IM_VK_PRINTSCREEN", 	154},
	{(char *)"IM_VK_INSERT", 	155},
	{(char *)"IM_VK_HELP", 	156},
	{(char *)"IM_VK_META", 	157},
	{(char *)"IM_VK_BACK_QUOTE", 	192},
	{(char *)"IM_VK_QUOTE", 	222},
	{(char *)"IM_VK_KP_UP", 	224},
	{(char *)"IM_VK_KP_DOWN", 	225},
	{(char *)"IM_VK_KP_LEFT", 	226},
	{(char *)"IM_VK_KP_RIGHT", 	227},
	{(char *)"IM_VK_DEAD_GRAVE", 	128},
	{(char *)"IM_VK_DEAD_ACUTE", 	129},
	{(char *)"IM_VK_DEAD_CIRCUMFLEX", 	130},
	{(char *)"IM_VK_DEAD_TILDE", 	131},
	{(char *)"IM_VK_DEAD_MACRON", 	132},
	{(char *)"IM_VK_DEAD_BREVE", 	133},
	{(char *)"IM_VK_DEAD_ABOVEDOT", 	134},
	{(char *)"IM_VK_DEAD_DIAERESIS", 	135},
	{(char *)"IM_VK_DEAD_ABOVERING", 	136},
	{(char *)"IM_VK_DEAD_DOUBLEACUTE", 	137},
	{(char *)"IM_VK_DEAD_CARON", 	138},
	{(char *)"IM_VK_DEAD_CEDILLA", 	139},
	{(char *)"IM_VK_DEAD_OGONEK", 	140},
	{(char *)"IM_VK_DEAD_IOTA", 	141},
	{(char *)"IM_VK_DEAD_VOICED_SOUND", 	142},
	{(char *)"IM_VK_DEAD_SEMIVOICED_SOUND", 	143},
	{(char *)"IM_VK_AMPERSAND", 	150},
	{(char *)"IM_VK_ASTERISK", 	151},
	{(char *)"IM_VK_QUOTEDBL", 	152},
	{(char *)"IM_VK_LESS", 	153},
	{(char *)"IM_VK_GREATER", 	160},
	{(char *)"IM_VK_BRACELEFT", 	161},
	{(char *)"IM_VK_BRACERIGHT", 	162},
	{(char *)"IM_VK_AT", 	512},
	{(char *)"IM_VK_COLON", 	513},
	{(char *)"IM_VK_CIRCUMFLEX", 	514},
	{(char *)"IM_VK_DOLLAR", 	515},
	{(char *)"IM_VK_EURO_SIGN", 	516},
	{(char *)"IM_VK_EXCLAMATION_MARK", 	517},
	{(char *)"IM_VK_INVERTED_EXCLAMATION_MARK", 	518},
	{(char *)"IM_VK_LEFT_PARENTHESIS", 	519},
	{(char *)"IM_VK_NUMBER_SIGN", 	520},
	{(char *)"IM_VK_PLUS", 	521},
	{(char *)"IM_VK_RIGHT_PARENTHESIS", 	522},
	{(char *)"IM_VK_UNDERSCORE", 	523},
	{(char *)"IM_VK_FINAL", 	24},
	{(char *)"IM_VK_CONVERT", 	28},
	{(char *)"IM_VK_NONCONVERT", 	29},
	{(char *)"IM_VK_ACCEPT", 	30},
	{(char *)"IM_VK_MODECHANGE", 	31},
	{(char *)"IM_VK_KANA", 	21},
	{(char *)"IM_VK_KANJI", 	25},
	{(char *)"IM_VK_ALPHANUMERIC", 	240},
	{(char *)"IM_VK_KATAKANA", 	241},
	{(char *)"IM_VK_HIRAGANA", 	242},
	{(char *)"IM_VK_FULL_WIDTH", 	243},
	{(char *)"IM_VK_HALF_WIDTH", 	244},
	{(char *)"IM_VK_ROMAN_CHARACTERS", 	245},
	{(char *)"IM_VK_ALL_CANDIDATES", 	256},
	{(char *)"IM_VK_PREVIOUS_CANDIDATE", 	257},
	{(char *)"IM_VK_CODE_INPUT", 	258},
	{(char *)"IM_VK_JAPANESE_KATAKANA", 	259},
	{(char *)"IM_VK_JAPANESE_HIRAGANA", 	260},
	{(char *)"IM_VK_JAPANESE_ROMAN", 	261},
	{(char *)"IM_VK_CUT", 	65489},
	{(char *)"IM_VK_COPY", 	65485},
	{(char *)"IM_VK_PASTE", 	65487},
	{(char *)"IM_VK_UNDO", 	65483},
	{(char *)"IM_VK_AGAIN", 	65481},
	{(char *)"IM_VK_FIND", 	65488},
	{(char *)"IM_VK_PROPS", 	65482},
	{(char *)"IM_VK_STOP", 	65480},
	{(char *)"IM_VK_COMPOSE", 	65312},
	{(char *)"IM_VK_ALT_GRAPH", 	65406},
	{(char *)"IM_VK_UNDEFINED", 	0},
	{0, 0}
};

/* 
   read profile from file "sysime.cfg" to memory buffer   
   the struct of sysime.cfg is as follow:

   # comments
   # engine_options can be the path of the dictionary or options that
   # the engine can recognize.
   [ GENERIC_IM_TABLE ]

   [ locale_name ]
   engine_name		engine_path	  engine_options default_conv_mode

   for example:
   [ HINDI ]  
   trans	common/ctim.so 
   iscii common/ctim.so 

   [ TAMIL ]  
   trans	common/ctim.so 
   iscii common/ctim.so 

*/ 

int unit_ns_read_config(unit_desktop_t *, char *, int);
int unit_ns_callback(int, int, char *, void *);
int get_line(char *buf, int size, char **curptr, char *line);
int set_keyvalues(unit_desktop_t *udp, char *buf, char *Lname);
int open_engine(unit_desktop_t *udp, int locale_id, char *locale_name, 
		char *engine_name, char *engine_path, char *engine_options, char *cflag);

void  
getNEngineIds(unit_desktop_t *udp){
    int i,j;
    int sflag,eflag;

    for(i=0; i<udp->locale_Num; i++){
	sflag=0;
	eflag=0;
	for(j=0; j<udp->gEngine_Num; j++) {
	    if(!strcmp(udp->localeList[i].locale_name, udp->modeList[j]->locale_name)){
		if(!sflag){
		    udp->localeList[i].firstEngineId = udp->modeList[j]->engine_id;
		    sflag=1;
		}
		udp->localeList[i].nEngineId++;
		if((i == (udp->locale_Num - 1)) && (j == (udp->gEngine_Num -1)))
		    udp->localeList[i].lastEngineId = udp->modeList[j]->engine_id;
	    }else{
		if(sflag && !eflag){
		    udp->localeList[i].lastEngineId = udp->modeList[j-1]->engine_id;
		    eflag=1;
		}
	    }
	}
    }

    for(i=0; i<udp->locale_Num; i++)
	log_f("getNEngineIds: locale_name [%s], start [%d], last [%d], nEngineIds [%d]\n",udp->localeList[i].locale_name, udp->localeList[i].firstEngineId, udp->localeList[i].lastEngineId, udp->localeList[i].nEngineId);
}

void  
print_core(unit_desktop_t *udp)
{
    int i;

    log_f("gEngine_Num:%d\n", udp->gEngine_Num);
    for (i=0; i<udp->gEngine_Num; i++) {
	log_f("localeid:%d, imid:%d, ename:%s, lname: %s, cname:%s, status:%d\n", 
	      udp->gEngine_Info[i]->core.baseinfo.locale_id,
	      udp->gEngine_Info[i]->core.baseinfo.engine_id,
	      udp->gEngine_Info[i]->core.baseinfo.ename,
	      udp->gEngine_Info[i]->core.baseinfo.lname,
	      udp->gEngine_Info[i]->core.baseinfo.cname,
	      udp->gEngine_Info[i]->core.baseinfo.status);
    }
    for (i=0; i<udp->gEngine_Num; i++) {
	log_f("print_core: locale_name [%s], engine_name [%s], engine_id [%d], default_state [%s] \n",udp->modeList[i]->locale_name, udp->modeList[i]->engine_name, udp->modeList[i]->engine_id, udp->modeList[i]->default_state);
	log_f("print_core: nlocale_name [%s], nlayout_name [%s]\n",udp->modeList[i]->nlocale_name, udp->modeList[i]->nlayout_name);
    }
    log_f("print_core: udp->nextLocaleKeycode [%d] \n",udp->nextLocaleKeycode);
    log_f("print_core: udp->nextLocaleModifier [%d] \n",udp->nextLocaleModifier);
    log_f("print_core: udp->prevLocaleKeycode [%d] \n",udp->prevLocaleKeycode);
    log_f("print_core: udp->prevLocaleModifier [%d] \n",udp->prevLocaleModifier);
    log_f("print_core: udp->layoutNameKeyCode [%d] \n",udp->layoutNameKeyCode);
    log_f("print_core: udp->layoutNameModifier [%d] \n",udp->layoutNameModifier);
}

void 
unit_desktop_init(unit_desktop_t *udp) {
    int i;

    if (udp->gEngine_Num > 0)
	return;

    udp->gEngine_Num = 0;
    udp->locale_Num = 0;
    udp->nextLocaleKeycode = 0;
    udp->nextLocaleModifier = 0;
    udp->prevLocaleKeycode = 0;
    udp->prevLocaleModifier = 0;
    udp->layoutNameKeyCode = 0;
    udp->layoutNameModifier = 0;
    udp->curr_hotkey_profile_id = -1;
    udp->localeList = (LocaleList *)NULL;
    for (i=0; i<MAX_ENGINE_NUM; i++)
	udp->gEngine_Info[i] = NULL;

    return;
}

int 
unit_ns_callback(
    int listener_id,
    int fsize, 
    char *buf, 
    void *calldata
)
{
    char file_name[PATH_MAX];
    FILE *fp;
    int fd, size, nfread;
    struct stat stat_buf;
    char *file_buf;
    iml_nsl *nsl = (iml_nsl *) calldata;
    unit_desktop_t *udp = nsl->calldata;

    if (!fsize) {
	log_f("Namespace not defined, read from default location \n");
	snprintf(file_name, sizeof(file_name), "%s/%s/%s",  DEFAULT_ENGINE_PATH, XAUX_LOCALE_NAME, SYSTEM_PROFILE_NAME);
	log_f("file name :%s\n",file_name);
	fp = fopen(file_name, "r");
	if (! fp)
	    return (-1);
	fd = fileno((FILE *)fp);
	if (fstat(fd, &stat_buf) < 0) {
	    return -1;
	}
	size = stat_buf.st_size;
	log_f("size [%d]\n",size);
	file_buf = (char *)calloc(size, sizeof(char));
	nfread = fread(file_buf, size, 1, fp);
	log_f("nfread [%d]\n",nfread);
	unit_ns_read_config(udp, file_buf, size);
        return 0;
    }
    unit_ns_read_config(udp, buf, fsize);
    return 0;
}
    
int
unit_ns_read_config(
    unit_desktop_t *udp,
    char *buf,
    int fsize
)
{
    char          line[MAX_LINE_LEN];
    char          keyCodeName[NAME_MAX], modifierName[NAME_MAX];
    char          locale_name[NAME_MAX], *kptr, *ptr;
    char          *engine_name, *engine_path, *engine_options, *conv_flag;
    int           len;
    int           locale_flag = ENCODE_ERROR;
    int           generic_flag = 0;
    int           switch_to_next_locale_flag = 0;
    int           switch_to_prev_locale_flag = 0;
    int           switch_layout_flag = 0;
    char          *curr_ptr;

    memset((char *)keyCodeName,'\0',sizeof(keyCodeName));
    memset((char *)modifierName,'\0',sizeof(modifierName));

    numLocales = 0;
    curr_ptr = 0;
    do {
        len = get_line(buf, fsize, &curr_ptr, line);

        if (!len) break;
        if (len < 0) continue;

        if (line[0] == '[' && line[len-1] == ']') {
            /* compute locale_flag */
            ptr = line + 1;
            while(isspace(*ptr)) ptr++;

            memset((char *)locale_name,'\0',sizeof(locale_name));
            /* get locale section name */
            kptr = locale_name;
            while (*ptr && !isspace(*ptr) && *ptr!=']')
                *(kptr++) = *(ptr++);
            *kptr = '\0';

            /* get locale section name */
            if (!strcasecmp(locale_name, COMMON_ENGINE_PATH))
                locale_flag = ENCODES_NUM;
            else if(!strcasecmp(locale_name, GENERIC_IM_TABLE_NAME)){
                generic_flag = 1;
                continue;
            }else if(!strcasecmp(locale_name, SWITCH_TO_NEXT_LOCALE)){
                switch_to_next_locale_flag = 1;
                continue;
            }else if(!strcasecmp(locale_name, SWITCH_TO_PREV_LOCALE)){
                switch_to_prev_locale_flag = 1;
                continue;
            }else if(!strcasecmp(locale_name, SWITCH_LAYOUT_NAME)){
                switch_layout_flag = 1;
                continue;
            }else {
                if(!switch_to_next_locale_flag && (udp->nextLocaleKeycode == 0 && udp->nextLocaleModifier == 0)){
                    udp->nextLocaleKeycode = IM_VK_F5;
                    udp->nextLocaleModifier = 0;
                    continue;
                } else if(!switch_to_prev_locale_flag && (udp->prevLocaleKeycode == 0 && udp->prevLocaleModifier == 0)){
                    udp->prevLocaleKeycode = IM_VK_F7;
                    udp->prevLocaleModifier = 0;
                    continue;
                }else if(!switch_layout_flag && (udp->layoutNameKeyCode == 0 && udp->layoutNameModifier == 0)){
                    udp->layoutNameKeyCode = IM_VK_F6;
                    udp->layoutNameModifier = 0;
                    continue;
                }
            }

            if(!generic_flag)
                locale_flag = get_encodeid_from_locale(locale_name);
            else{
                locale_flag = ENCODES_NUM;
                if(!udp->localeList){
                    udp->localeList = (LocaleList *)calloc(1, sizeof(LocaleList));
                }else{
                    udp->localeList = (LocaleList *) realloc((LocaleList *)udp->localeList,
                                                             (udp->locale_Num+1)*sizeof(LocaleList));
                }
                if(!udp->localeList)
                    log_f("Error in calloc/realloc for LocaleList \n");

                udp->localeList[udp->locale_Num].locale_name = (char *)strdup(locale_name);
                /* Create the new supported language list */
                loc[udp->locale_Num].id = (char *)strdup(locale_name);
                loc[udp->locale_Num].name = (UTFCHAR *)calloc(strlen(locale_name)+1,sizeof(UTFCHAR));
                CpyUTFCHAR(locale_name, loc[udp->locale_Num].name);

                udp->localeList[udp->locale_Num].nEngineId = 0;
                log_f("udp->localeList[%d].locale_name [%s]\n",udp->locale_Num, udp->localeList[udp->locale_Num].locale_name);
                udp->locale_Num++;
            }
            log_f("locale_name:%s, locale_id:%d\n", locale_name, locale_flag);
            continue;
        }

        if (!strcasecmp(locale_name, SWITCH_TO_NEXT_LOCALE)){
            if(switch_to_next_locale_flag) {
                set_keyvalues(udp, line, locale_name);
                switch_to_next_locale_flag = 0;
                continue;
            }
        }

        if (!strcasecmp(locale_name, SWITCH_TO_PREV_LOCALE)){
            if(switch_to_prev_locale_flag) {
                set_keyvalues(udp, line, locale_name);
                switch_to_prev_locale_flag = 0;
                continue;
            }
        }

        if (!strcasecmp(locale_name, SWITCH_LAYOUT_NAME)){
            if (switch_layout_flag){
                set_keyvalues(udp, line, locale_name);
                switch_layout_flag = 0;
                continue;
            }
        }

        if (locale_flag == ENCODE_ERROR) continue;

        /* get IME language engine name */
        ptr = line;
        engine_name = line;
        while (*ptr && !isspace(*ptr)) ptr++;
        if (*ptr) {
            *ptr = '\0';
            ptr++;
        }

        while (*ptr && isspace(*ptr)) ptr++;
        engine_path = ptr;

        while (*ptr && !isspace(*ptr)) ptr++;
        if (*ptr) {
            *ptr = '\0';
            ptr++;
        }

        while (*ptr && isspace(*ptr)) ptr++;
        engine_options = ptr;

        while (*ptr && !isspace(*ptr)) ptr++;
        if (*ptr) {
            *ptr = '\0';
            ptr++;
        }
        while (*ptr && isspace(*ptr)) ptr++;
        conv_flag = ptr;

        log_f("locale_id:%d, locale:%s, Engine Name:%s\n", locale_flag, locale_name, engine_name);
        log_f("Engine Path: %s, Engine Options: %s, Conv_flag [%s] \n", engine_path, engine_options, conv_flag);
        open_engine(udp, locale_flag, locale_name,
                    engine_name, engine_path, engine_options, conv_flag);

    } while (1);

    loc[udp->locale_Num].id = (char *)NULL;
    loc[udp->locale_Num].name = (UTFCHAR *)NULL;

    numLocales = udp->locale_Num;

    if ((udp->nextLocaleKeycode == 0) && (udp->nextLocaleModifier == 0)){
        udp->nextLocaleKeycode = IM_VK_F5;
        udp->nextLocaleModifier = 0;
    }

    if ((udp->prevLocaleKeycode == 0) && (udp->prevLocaleModifier == 0)){
        udp->prevLocaleKeycode = IM_VK_F5;
        udp->prevLocaleModifier = 0;
    }
    if ((udp->layoutNameKeyCode == 0) && (udp->layoutNameModifier == 0)){
        udp->layoutNameKeyCode = IM_VK_F6;
        udp->layoutNameModifier = 0;
    }

    getNEngineIds(udp);

    /*  
     *  print_core(udp); 
     */
     print_core(udp); 

    return 0;

}

int
unit_desktop_add_listener(
    unit_desktop_t *udp,
    iml_session_t *s
)
{
    char          file_name[PATH_MAX];
    iml_nsl       *nsl;
    void          *nsl_callback;

    nsl_callback = unit_ns_callback;

    nsl = calloc(1, sizeof(iml_nsl));
    snprintf(file_name, sizeof(file_name), "%s/%s", XAUX_LOCALE_NAME, SYSTEM_PROFILE_NAME);
    nsl->path_name = file_name ;
    nsl->calldata = udp ; /* anything unit need */
    s->If->m->iml_add_listener(s, "iiim.le.io.listener", nsl_callback, nsl);
    return 0;
}

void
unit_desktop_set_curr_profile_id(
    unit_desktop_t *udp,
    int profile_id
)
{
    udp->curr_hotkey_profile_id = profile_id;
}

int
unit_desktop_get_curr_profile_id(
    unit_desktop_t *udp
)
{
    return udp->curr_hotkey_profile_id;
}

void
unit_desktop_switch_hotkey_profile(
    unit_desktop_t *udp,
    iml_session_t *s
)
{
    iml_hkc       *hkc;
    iml_hkc_create_t le_hkc_create;
    iml_hkc_free_t le_hkc_free;

    le_hkc_create = (iml_hkc_create_t) (s->desktop->If->hkc_get_function("_hkc_create"));
    le_hkc_free = (iml_hkc_free_t) (s->desktop->If->hkc_get_function("_hkc_free"));

    hkc = le_hkc_create("unitle", IML_HKC_TYPE_DESKTOP, s->desktop);

    unit_desktop_set_curr_profile_id(udp, IME_HOTKEY_PROFILE_TWO);
    s->desktop->If->switchLEProfile(s, IME_HOTKEY_PROFILE_TWO, &leName);

    le_hkc_free(hkc);
}

int
unit_desktop_load_engines(
    unit_desktop_t *udp,
    iml_desktop_t *desktop
)
{
    iml_nsc          *nsc;
    int              ns_id;
    char             file_name[PATH_MAX];
    int              fd, size, nread;
    char             *file_buf;
    struct stat      stat_buf;
    /*
    struct dirent    *dirp;
    DIR              *Dp;
    */
    FILE             *fp;
    iml_nsc_create_t le_nsc_create;
    iml_nsc_free_t   le_nsc_free;
#ifdef NSC_FIO_SET
    iml_nsc_basic_fioset_t *bfio;
#else
    iml_nsc_open_t le_open; 
    iml_nsc_stat_t le_stat;
    iml_nsc_read_t le_read;
    iml_nsc_close_t le_close;
    iml_nsc_umask_t le_umask;
    /*
    iml_nsc_lstat_t le_lstat;
    iml_nsc_opendir_t le_opendir;
    iml_nsc_readdir_t le_readdir;
    iml_nsc_closedir_t le_closedir;
    iml_nsc_mkdir_t le_mkdir;
    */
#endif

    le_nsc_create = (iml_nsc_create_t) (desktop->If->nsc_get_function("_nsc_create"));
    le_nsc_free = (iml_nsc_free_t) (desktop->If->nsc_get_function("_nsc_free"));

    nsc = le_nsc_create("unitle", IML_NSC_TYPE_DESKTOP, desktop);

#ifdef NSC_FIO_SET
    bfio = (iml_nsc_basic_fioset_t *) (desktop->If->nsc_get_function("_nsc_basicfioset"));
#else
    le_open = (iml_nsc_open_t) (desktop->If->nsc_get_function("open"));
    le_stat = (iml_nsc_stat_t) (desktop->If->nsc_get_function("stat"));
    le_read = (iml_nsc_read_t) (desktop->If->nsc_get_function("read"));
    le_close = (iml_nsc_close_t) (desktop->If->nsc_get_function("close"));
    le_umask = (iml_nsc_umask_t) (desktop->If->nsc_get_function("umask"));
    /*
    le_lstat = (iml_nsc_lstat_t) (desktop->If->nsc_get_function("lstat"));
    le_opendir = (iml_nsc_opendir_t) (desktop->If->nsc_get_function("opendir"));
    le_readdir = (iml_nsc_readdir_t) (desktop->If->nsc_get_function("readdir"));
    le_closedir = (iml_nsc_closedir_t) (desktop->If->nsc_get_function("closedir"));
    le_mkdir = (iml_nsc_mkdir_t) (desktop->If->nsc_get_function("mkdir"));
    */
#endif

    if (!le_umask) {
      log_f("iml_nsc_umask_t() not supported \n");
    }

    size = -1;
    snprintf(file_name, sizeof(file_name), "%s/%s/%s/%s", VAR_LE_DIR, XAUX_LOCALE_NAME, desktop->user_name, SYSTEM_PROFILE_NAME);

#ifdef NSC_FIO_SET
    if ((ns_id = bfio->open(nsc, file_name, O_RDWR)) < 0) {
#else
    if ((ns_id = le_open(nsc, file_name, O_RDWR )) < 0) {
#endif
/*
	log_f("open error [%d] [%s]\n", errno, sys_errlist[errno]);
*/
	log_f("Namespace not defined, read from default location \n");
	snprintf(file_name, sizeof(file_name), "%s/%s/%s",  DEFAULT_ENGINE_PATH, XAUX_LOCALE_NAME, SYSTEM_PROFILE_NAME);
	log_f("file name :%s\n",file_name);
	fp = fopen(file_name, "r");
	if (! fp)
	    return (-1);
	fd = fileno((FILE *)fp);
	if (fstat(fd, &stat_buf) < 0) {
	    return -1;
	}
	size = stat_buf.st_size;
	log_f("size [%d]\n",size);
	file_buf = (char *)calloc(size, sizeof(char));
	nread = fread(file_buf, size, 1, fp);
	log_f("nread [%d]\n",nread);
	unit_ns_read_config(udp, file_buf, size);
	if (numLocales) {
	    desktop->If->updateSupportedLocales(desktop, &leName, loc, numLocales);
	}
	fclose(fp);
	return 0;
    }

    memset(&stat_buf, '\0', sizeof(stat_buf));
#ifdef NSC_FIO_SET
    if ((bfio->stat(nsc, ns_id, &stat_buf)) < 0) {
	bfio->close(nsc, ns_id);
#else
    if ((le_stat(nsc, file_name, &stat_buf)) < 0) {
        le_close(nsc, ns_id);
#endif
	le_nsc_free(nsc);
	return 0;
    }

    if (stat_buf.st_size) {
	file_buf = (char *) calloc(stat_buf.st_size, sizeof(char));
#ifdef NSC_FIO_SET
	nread = bfio->read(nsc, ns_id, file_buf, stat_buf.st_size);
	if (nread <= 0) {
	    log_f("Error in read file \n");
	    bfio->close(nsc, ns_id);
	    return -1;
	}
#else
        nread = le_read(nsc, ns_id, file_buf, stat_buf.st_size);
        if (nread <= 0) {
            log_f("Error in read file \n");
            le_close(nsc, ns_id);
            return -1;
        }
#endif
	unit_ns_read_config(udp, file_buf, stat_buf.st_size);
  
	if (numLocales) {
	    desktop->If->updateSupportedLocales(desktop, &leName, loc, numLocales);
	}
    }
    le_close(nsc, ns_id);
    le_nsc_free(nsc);

    /*
      memset(&stat_buf, '\0', sizeof(stat_buf));
#ifdef NSC_FIO_SET
      if ((bfio->lstat(nsc, file_name, &stat_buf)) < 0) {
      bfio->close(nsc, ns_id);
      le_nsc_free(nsc);
      return 0;
      }
      bfio->close(nsc, ns_id);
#else
      if ((le_lstat(nsc, file_name, &stat_buf)) < 0) {
      le_close(nsc, ns_id);
      le_nsc_free(nsc);
      return 0;
      }
      le_close(nsc, ns_id);
#endif
      log_f("UNIT: file_size from lstat [%ld]\n",stat_buf.st_size);
      log_f("UNIT: mtime from lstat [%ld]\n",stat_buf.st_mtime);

#ifdef NSC_FIO_SET
      memset((char *)file_name,'\0',sizeof(file_name));
      snprintf(file_name, sizeof(file_name), "%s/%s/%s", VAR_LE_DIR, XAUX_LOCALE_NAME, desktop->user_name);
      Dp = bfio->opendir(nsc, file_name);
      while ((dirp = bfio->readdir(nsc, Dp)) != NULL) {
      log_f("UNIT: d_reclen [%x]\n", dirp->d_reclen);
      log_f("UNIT: d_name [%s]\n", dirp->d_name);
      }
      bfio->closedir(nsc, Dp);

      memset((char *)file_name,'\0',sizeof(file_name));
      snprintf(file_name, sizeof(file_name), "%s/%s/%s/%s", VAR_LE_DIR, XAUX_LOCALE_NAME, desktop->user_name, "testMKDIR");

      bfio->mkdir(nsc, file_name, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
#else
      memset((char *)file_name,'\0',sizeof(file_name));
      snprintf(file_name, sizeof(file_name), "%s/%s/%s", VAR_LE_DIR, XAUX_LOCALE_NAME, desktop->user_name);
      Dp = le_opendir(nsc, file_name);
      while ((dirp = le_readdir(nsc, Dp)) != NULL) {
      log_f("UNIT: d_reclen [%x]\n", dirp->d_reclen);
      log_f("UNIT: d_name [%s]\n", dirp->d_name);
      }
      le_closedir(nsc, Dp);

      memset((char *)file_name,'\0',sizeof(file_name));
      snprintf(file_name, sizeof(file_name), "%s/%s/%s/%s", VAR_LE_DIR, XAUX_LOCALE_NAME, desktop->user_name, "testMKDIR");

      le_mkdir(nsc, file_name, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
#endif

      le_nsc_free(nsc);
    */

    return 0;
}

int
get_line (
    char *buf,     /* in: pointer to entire buffer */
    int size,      /* in: size of entire buffer */
    char **curptr, /* inout: pointer to where it was last time
		    *        Has to be 0 when 1st time called
		    */
    char *line     /* out: One line without preceeding/trailing
		    *      space
		    */
)
{
    int line_ptr, n;
    char line_buf[MAX_LINE_LEN]; 
    char *ptr;

    char *p = ((0 == *curptr)?*curptr=buf:*curptr);
    char *pp = p;

    line_ptr = 0;
    line[0] = '\0';

    n = *curptr - buf;
    if (n >= size) { /* No more data to read */
	return 0;
    }

    /* get line with no space */
    while(1) {
        if (*p == '\n' || *p == '\0') {
            *p++;
            continue;
        }

	/* chop one line */
	while (*p != '\n') p++ ;
	/* pp to p is one line, just as fgets returns */
	memcpy(line_buf, pp, p-pp);
	line_buf[p-pp]='\0';

	ptr = line_buf;

	/* skip preceding space keys */
	while(*ptr && isspace(*ptr)) ptr++;

	/* if is space line, get new line */
	if (*ptr == '\n' || *ptr == '\0')
	    continue;

	while(*ptr != '\n' && *ptr != '\0' && line_ptr < MAX_LINE_LEN)
	    line[line_ptr++] = *ptr++;

	/* trim right space */
	while (isspace(line[line_ptr-1])) line_ptr--;
	line[line_ptr] = '\0';

	/* if the line end with '\', then continue read the next line */
	if (line[line_ptr-1] == '\\') {
	    line_ptr--;
	    line[line_ptr] = '\0';
	    continue;
	} 
	break;
    }

    *curptr = p+1 ;

    if (line[0] == '\0') return 0;
    if (line[0] == COMMENT) return -1; 
    return line_ptr;
}

/* engine_options can be data_path or engine options. */
int 
open_engine(udp, locale_id, locale_name, engine_name, engine_path, engine_options, conv_flag)
    unit_desktop_t *udp;
int 	locale_id;
char 	*locale_name;
char 	*engine_name;
char 	*engine_path;
char 	*engine_options;
char 	*conv_flag;
{
    int    		ret, i;
    char   		file_name[PATH_MAX];
    struct stat 	file_buffer;

    void   		*so_handler;
    IMEMethods	methods;

    int 		is_codetable_engine = 0;

    if (udp->gEngine_Num > MAX_ENGINE_NUM) return (-1);
    
    /* read profile from file to memory buffer  */ 
    if (*engine_path) {
	if (engine_path[0] != '/') 
	    snprintf(file_name, sizeof(file_name), "%s/%s/%s",  DEFAULT_ENGINE_PATH, 
		     XAUX_LOCALE_NAME, 
		     engine_path);
	else
	    snprintf(file_name, sizeof(file_name), "%s", engine_path);
    } else {
	is_codetable_engine = 1;
	snprintf(file_name, sizeof(file_name), "%s/%s/%s/%s.so", DEFAULT_ENGINE_PATH, 
		 XAUX_LOCALE_NAME, 
		 locale_name, 
		 engine_name);
    }

    if ((stat(file_name, &file_buffer)) == -1)
	{ 
	    if (is_codetable_engine) {
		snprintf(file_name, sizeof(file_name),  "%s/%s/%s/%s.so", DEFAULT_ENGINE_PATH, 
			 XAUX_LOCALE_NAME, 
			 COMMON_ENGINE_PATH, 
			 CODETABLE_ENGINE_NAME);
		if ((stat(file_name, &file_buffer)) == -1)
		    return (-1);
	    } else {
		return (-1);
	    }
	}
    log_f("so_file_name:%s\n", file_name);

    so_handler = (void *) dlopen(file_name, RTLD_LAZY);
    if (!so_handler) {
	log_f("can not open so file: %s\n", file_name);
	return (-1);
    } else {
	methods = (IMEMethods) dlsym(so_handler, "ime_methods");
	if (!methods) {
	    log_f("can not open method tables of file:%s\n", file_name);
	    dlclose(so_handler);
	    return(-1);
	}
    }

    udp->gEngine_Info[udp->gEngine_Num] = (IMEEngineRec *)calloc(1, sizeof(IMEEngineRec));
    if (udp->gEngine_Info[udp->gEngine_Num] == NULL) return(0);

    udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.engine_id = udp->gEngine_Num;
    udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.locale_id = locale_id;
    udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.status = ENGINE_NOT_INITIATED;
    udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.ename = (char *)strdup(engine_name);

    udp->gEngine_Info[udp->gEngine_Num]->core.envinfo.lang_name = (char *)strdup(XAUX_LOCALE_NAME);
    udp->gEngine_Info[udp->gEngine_Num]->core.envinfo.locale_name = (char *)strdup(locale_name);
    udp->gEngine_Info[udp->gEngine_Num]->core.envinfo.data_path = NULL;
    udp->gEngine_Info[udp->gEngine_Num]->core.envinfo.data_ptr = NULL;

    udp->gEngine_Info[udp->gEngine_Num]->core.keymapinfo.bSet = 0;
    for (i=0; i<MAX_KEYMAP_KEY_NUM; i++) 
	udp->gEngine_Info[udp->gEngine_Num]->core.keymapinfo.keymap[i] = NULL;

    udp->gEngine_Info[udp->gEngine_Num]->so_handler = so_handler;
    udp->gEngine_Info[udp->gEngine_Num]->so_methods = methods;

    /* IME_SetValues: set the arguments of this IME */
    ret = methods->IME_SetOptions(&(udp->gEngine_Info[udp->gEngine_Num]->core), engine_options);
    if (ret == -1) {
	log_f("Not successfully set options of the input method engine:%s\n",engine_name);
	dlclose(so_handler);
	return(-1);
    }

    /* IME_Init: get the status, lname, cname, encode information of this Input Method engine */
    ret = methods->IME_Init(&(udp->gEngine_Info[udp->gEngine_Num]->core));
    if (ret == -1) {
	log_f("Not successfully initialize the input method engine:%s\n",engine_name);
	dlclose(so_handler);
	return(-1);
    }

    udp->modeList[udp->gEngine_Num] = (IMEModeList *)calloc(1, sizeof(IMEModeList));
    if (udp->modeList[udp->gEngine_Num] == NULL) return(0);

    log_f("open_engine: nlocale_name [%s], nlayout_name [%s]\n",udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.lname, udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.cname);
    udp->modeList[udp->gEngine_Num]->locale_name = (char *)strdup(locale_name);
    udp->modeList[udp->gEngine_Num]->nlocale_name = (char *)strdup(udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.lname);
    udp->modeList[udp->gEngine_Num]->nlayout_name = (char *)strdup(udp->gEngine_Info[udp->gEngine_Num]->core.baseinfo.cname);
    udp->modeList[udp->gEngine_Num]->engine_id = udp->gEngine_Num;
    udp->modeList[udp->gEngine_Num]->engine_name = (char *)strdup(engine_name);
    udp->modeList[udp->gEngine_Num]->default_state = (char *)strdup(conv_flag);

    udp->gEngine_Num++;
    return(0);
}

void 
unit_desktop_done(unit_desktop_t *udp)
{
    int i;
    char *name;

    for (i=0; i<udp->gEngine_Num; i++) {
	name = udp->gEngine_Info[i]->core.baseinfo.ename;
	if (name) free(name);

	name = udp->gEngine_Info[i]->core.envinfo.lang_name;
	if (name) free(name);

	name = udp->gEngine_Info[i]->core.envinfo.locale_name;
	if (name) free(name);

	udp->gEngine_Info[i]->so_methods->IME_Close(&(udp->gEngine_Info[i]->core));
	dlclose(udp->gEngine_Info[i]->so_handler);
	free((char *)udp->gEngine_Info[i]);

	name = udp->modeList[i]->locale_name;
	if (name) free(name);

	name = udp->modeList[i]->nlocale_name;
	if (name) free(name);

	name = udp->modeList[i]->nlayout_name;
	if (name) free(name);

	name = udp->modeList[i]->engine_name;
	if (name) free(name);

	free((char *)udp->modeList[i]);
	udp->modeList[i] = 0;
    }
    udp->gEngine_Num = 0;

    for(i=0; i<udp->locale_Num; i++){
	name = udp->localeList[i].locale_name;
	if (name) free(name);
    }
    free((LocaleList *)udp->localeList);
    udp->localeList = 0;
}

int get_key_value(char *key_str){
    int i;
    for (i = 0; kvp[i].key_name != 0; i++) {
        if(!strcmp(kvp[i].key_name, key_str)){
            return kvp[i].value;
        }
    }
    return 0;
}

int set_keyvalues(unit_desktop_t *udp, char *buf, char *Lname){
    char *keycode_name, *modifier_name;
    char *ptr;
    int flag;

    flag = 0;
    ptr = buf;
    keycode_name = buf;

    while (*ptr && !isspace(*ptr)){
	if (isalpha(*ptr)){
	    flag = 1;
	}
	ptr++;
    }

    if (*ptr) {
	*ptr = '\0';
	ptr++;
    }

    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)) {
	log_f("SWITCH_TO_NEXT_LOCALE: keycode_name <%s>\n",keycode_name);
    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)) {
	log_f("SWITCH_TO_PREV_LOCALE: keycode_name <%s>\n",keycode_name);
    } else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)) {
	log_f("SWITCH_LAYOUT: keycode_name <%s>\n",keycode_name);
    }
   
    if (flag){
	if ((keycode_name[0] == 'I') && (keycode_name[1] == 'M')){
	    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)) {
		udp->nextLocaleKeycode = get_key_value(keycode_name);
	    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)) {
		udp->prevLocaleKeycode = get_key_value(keycode_name);
	    } else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)) {
		udp->layoutNameKeyCode = get_key_value(keycode_name); 
	    }
	}else{
	    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)) {
		udp->nextLocaleKeycode = (UTFCHAR)strtol(keycode_name, NULL, 16);
	    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)) {
		udp->prevLocaleKeycode = (UTFCHAR)strtol(keycode_name, NULL, 16);
	    } else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)) {
		udp->layoutNameKeyCode = (UTFCHAR)strtol(keycode_name, NULL, 16);
	    }
	}
    }else{
	if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)) {
	    udp->nextLocaleKeycode = atoi(keycode_name);
	} else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)) {
	    udp->prevLocaleKeycode = atoi(keycode_name);
	} else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)) {
	    udp->layoutNameKeyCode = atoi(keycode_name);
	}
    }

    while (*ptr && isspace(*ptr)) ptr++;
    modifier_name = ptr;

    while (*ptr && !isspace(*ptr)){
	if (isalpha(*ptr)){
	    flag = 1;
	}
	ptr++;
    }
    if (*ptr) {
	*ptr = '\0';
	ptr++;
    }

    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)) {
	log_f("SWITCH_TO_NEXT_LOCALE: modifier_name <%s>\n",modifier_name);
    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)) {
	log_f("SWITCH_TO_PREV_LOCALE: modifier_name <%s>\n",modifier_name);
    } else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)) {
	log_f("SWITCH_LAYOUT: modifier_name <%s>\n",modifier_name);
    }

    if (flag){
	if ((modifier_name[0] == 'I') && (modifier_name[1] == 'M')){
	    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)){
		udp->nextLocaleModifier = get_key_value(modifier_name);
	    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)){
		udp->prevLocaleModifier = get_key_value(modifier_name);
	    }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
		udp->layoutNameModifier = get_key_value(modifier_name);
	    }
	}else{
	    if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)){
		udp->nextLocaleModifier = (UTFCHAR)strtol(modifier_name, NULL, 16);
	    } else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)){
		udp->prevLocaleModifier = (UTFCHAR)strtol(modifier_name, NULL, 16);
	    }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
		udp->layoutNameModifier = (UTFCHAR)strtol(modifier_name, NULL, 16);
	    }
	}
    }else{
	if (!strcasecmp(Lname, SWITCH_TO_NEXT_LOCALE)){
	    udp->nextLocaleModifier = atoi(modifier_name);
	} else if (!strcasecmp(Lname, SWITCH_TO_PREV_LOCALE)){
	    udp->prevLocaleModifier = atoi(modifier_name);
	}else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
	    udp->layoutNameModifier = atoi(modifier_name);
	}
    }
    return 1;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
