/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <sys/types.h>
#include <dlfcn.h>
#include <strings.h>
#include <stdlib.h>
#include <string.h>

#include "unit_input.h"
#include "codepoint_im.h"
#include "codepoint_filter.h"
#include "codepoint_table.h"
#include "logf.h"

int  codepoint_SetOptions(IMECore, char *);
int  codepoint_SetValues(IMECore, IMEArgList, int);
int  codepoint_Init(IMECore);
int  codepoint_Open(IMECore, IMEBuffer, void *handler);
int  codepoint_Filter(IMECore, IMEKey, IMEArgList, IMEBuffer);
void codepoint_Close(IMECore);

#ifdef WIN32
#define EXPORT extern __declspec(dllexport)
EXPORT
#endif

/* IF Method */
IMEMethodsRec ime_methods = {
  codepoint_SetOptions,
  codepoint_SetValues,
  codepoint_Init,
  codepoint_Open,
  codepoint_Filter,
  codepoint_Close
};

/* Set options for codetable input method. */
int codepoint_SetOptions(IMECore core, char *options) {
  char data_path[256];

  /* Change path : /usr/lib/im/locale/UNIT/<options>/codepoint.cfg */
  sprintf(data_path, "%s/%s/%s/%s", DEFAULT_ENGINE_PATH, core->envinfo.lang_name, options, CODEPOINT_CONFIG_NAME);

  core->envinfo.data_path = (char *)strdup(data_path);
  log_f("codepoint_im: data_path :%s\n", core->envinfo.data_path);

  return (0);
}

int codepoint_SetValues(IMECore core, IMEArgList arglist, int option_value) {
  log_f("codepoint_im: codepoint_SetValues === \n");
  
  if (arglist == NULL) return(-1);

  arglist->args_num = 0;
  return(0);
}

/* return the name and encode status and status of codetable IME */

int codepoint_Init(IMECore core) {
  int  ret;
  char *file_name;
  TableStruct tHeader;

  log_f("codepoint_im: codepoint_Init ====\n");

  /* read table from file to memory buffer  */
  file_name = core->envinfo.data_path;
  log_f("codepoint_im: file name :%s\n",file_name);
  
  ret = LoadTableHeader(file_name, &tHeader); 
  if (ret == -1) 
    return (-1);

  /* Return Information that needed by Input Method Manager */
  /* Such as Encode, Cname, Status, InputType */
  
  core->baseinfo.status = ENGINE_NOT_INITIATED;
  log_f("Lname:%s\n",tHeader.Lname);
  core->baseinfo.lname = (char *)strdup(tHeader.Lname);
  log_f("Cname:%s\n",tHeader.Cname);
  core->baseinfo.cname = (char *)strdup(tHeader.Cname);
  log_f("encode_id:%d\n",tHeader.Encode);
  core->baseinfo.encode_id = tHeader.Encode;
  log_f("Engine_id:%d\n",core->baseinfo.engine_id);

  log_f("UsedCodes:%s\n",tHeader.UsedCodes);
  log_f("InputType:%s\n",tHeader.InputType);
  log_f("Default Input Len:%d\n",tHeader.Default_Input);
  log_f("Max Input Len:%d\n",tHeader.Max_Input);

  return(0);
}

int codepoint_Open(IMECore core, IMEBuffer ime_buffer, void *handler) {
  char *file_name;
  int ret;
  TableStruct *tHeader;

  log_f("codepoint_im: codepoint_Open ==== \n");

  ime_buffer->encode = 0;
  ime_buffer->return_status = 0;
  /*
    ime_buffer->preedit_len = 0;
    ime_buffer->inputkey_len = 0;
  */
  ime_buffer->commit_len  = 0;
  ime_buffer->lookup_num  = 0;
  ime_buffer->cur_lookup_pos = 0;


  if (core->baseinfo.status == ENGINE_NOT_INSTALLED){
    log_f("codepoint_Open: ENGINE_NOT_INSTALLED \n");
    return(-1);
  }

  if (core->baseinfo.status == ENGINE_INITIATED) {
    return 0;
  }

  core->baseinfo.status = ENGINE_NOT_INSTALLED;
                                                                                
  /* read table from file to memory buffer  */
  file_name = core->envinfo.data_path;
  log_f("file name :%s\n",file_name);
                                                                                
  tHeader = (TableStruct *)calloc(1, sizeof(TableStruct));
  if (tHeader == NULL) {
    fprintf(stderr, "no memory for CodeTable Input method: %s\n",core->baseinfo.ename);
    return(-1);
  }
                                                                                
  ret = LoadTableHeader(file_name, tHeader);
  if (ret == -1) {
    free((char *)tHeader);
    return(-1);
  }

  core->baseinfo.status = ENGINE_INITIATED;
  core->envinfo.data_ptr = (char *)tHeader;

  return(0);
}

/* close IME, and free codetable pointers */
void codepoint_Close(IMECore core) {
  log_f("codepoint_im: codepoint_Close ==== \n");

  if (core->baseinfo.lname)
    free((char *)core->baseinfo.lname);
  if (core->baseinfo.cname)
    free((char *)core->baseinfo.cname);
  if (core->envinfo.data_path)
    free((char *)core->envinfo.data_path);
}

/* process key input event                                             */
/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return   */
/*                                   this key to systerm directly      */
/*                IME_USED_KEY:      if IME has used this key          */

int  codepoint_Filter(core, key_event, ime_args, ime_buffer)
     IMECore core;
     IMEKey  key_event;
     IMEArgList ime_args;
     IMEBuffer ime_buffer;
{
  int ret;
  TableStruct *tHeader;

  log_f("codepoint_im: codepoint_Filter ==== \n");

  if (core->baseinfo.status != ENGINE_INITIATED){
    log_f("codepoint_Filter: ENGINE_NOT_INITIATED \n");
    return(IME_NOT_USED_KEY);
  }

  /* tHeader's argument setting are always coveried by user defined data */
  tHeader = (TableStruct *)(core->envinfo.data_ptr);
  tHeader->Output_Encode = core->envinfo.output_encode_id;

  ret = codepoint_filter(tHeader, key_event, ime_buffer);
  log_f("codepoint_im: codepoint_filter : return: %d\n", ret);
  return(ret);
}

