#include <stdio.h>

#include "le_object.h"
#include "le_info.h"

Bool if_le_OpenIF(iml_if_t *);
Bool if_le_CloseIF(iml_if_t *);
Bool if_le_GetIFValue(iml_if_t *, IMArgList, int);
Bool if_le_SetIFValue(iml_if_t *, IMArgList, int);
Bool if_le_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_le_CloseDesktop(iml_desktop_t *);
Bool if_le_CreateSC(iml_session_t *, IMArgList, int);
Bool if_le_DestroySC(iml_session_t *);
Bool if_le_GetSCValue(iml_session_t *, IMArgList, int);
Bool if_le_SetSCValue(iml_session_t *, IMArgList, int);
IMText *if_le_ResetSC(iml_session_t *);
void if_le_SetSCFocus(iml_session_t *);
void if_le_UnsetSCFocus(iml_session_t *);
void if_le_SendEvent(iml_session_t *, IMInputEvent * ev);

/* IF Method */
if_methods_t le_methods = {
    if_le_OpenIF,
    if_le_CloseIF,
    if_le_GetIFValue,
    if_le_SetIFValue,
    if_le_OpenDesktop,
    if_le_CloseDesktop,
    if_le_CreateSC,
    if_le_DestroySC,
    if_le_GetSCValue,
    if_le_SetSCValue,
    if_le_ResetSC,
    if_le_SetSCFocus,
    if_le_UnsetSCFocus,
    if_le_SendEvent
};

LeInfoRec   *le_info = NULL;
LeObjectRec *le_object = NULL;

/* htt_server get the IF information when start htt_server */
void if_GetIfInfo(IMArgList args, int num_args)
{
    int i;

    DEBUG_printf("if_GetIfInfo(), num_args: %d\n", num_args);

    if (le_object == NULL) {
        le_object = (LeObjectRec *)le_object_new();
    }
    if (le_object == NULL)
        return;

    for (i = 0; i < num_args; i++, args++) {
	switch (args->id) {
	case IF_VERSION:
	    args->value = (IMArgVal) le_object->version;
	    break;
	case IF_METHOD_TABLE:
	    args->value = (IMArgVal) & le_methods;
	    break;
	case IF_LE_NAME:
	    args->value = (IMArgVal) le_object->lename;
	    break;
	case IF_SUPPORTED_LOCALES:
	    args->value = (IMArgVal) le_object->locales;
	    break;
	case IF_SUPPORTED_OBJECTS:
	    args->value = (IMArgVal) le_object->objects;
	    break;
	case IF_NEED_THREAD_LOCK:
	    args->value = (IMArgVal) LE_OK;
	    break;
	default:
	    break;
	}
    }
}

/* Open the IF interface */
Bool if_le_OpenIF(iml_if_t * If)
{
    DEBUG_printf("if_le_OpenIF()\n");

    if (le_info == NULL) {
	le_info = (LeInfoRec *) le_info_new();
	if (le_info == NULL)
	    return (LE_FAIL);
    }

    le_info_print(le_info);
    return (LE_OK);
}

/* Close the IF interface */
Bool if_le_CloseIF(iml_if_t * If)
{
    DEBUG_printf("if_le_CloseIF()\n");

    le_object_destroy(le_object);
    le_object = NULL;

    le_info_destroy(le_info);
    le_info = NULL;

    return (LE_OK);
}

Bool if_le_GetIFValue(iml_if_t * If, IMArgList args, int num_args)
{
    DEBUG_printf("if_le_GetIFValue()\n");
    return (LE_OK);
}

Bool if_le_SetIFValue(iml_if_t * If, IMArgList args, int num_args)
{
    DEBUG_printf("if_le_SetIFValue()\n");
    return (LE_OK);
}

Bool if_le_OpenDesktop(iml_desktop_t * desktop, IMArgList args,
		       int num_args)
{
    DEBUG_printf("if_le_OpenDesktop(), desktop: %p, user: %s, host: %s\n",
	 	 desktop, desktop->user_name, desktop->host_name);

    le_desktop_create(desktop);
    return (LE_OK);
}

Bool if_le_CloseDesktop(iml_desktop_t * desktop)
{
    DEBUG_printf("if_le_CloseDesktop(), desktop: %p\n", desktop);

    le_desktop_destroy(desktop);
    return (LE_OK);
}

Bool if_le_CreateSC(iml_session_t * s, IMArgList args, int num_args)
{
    DEBUG_printf("if_le_CreateSC(), s: %p, num_args: %d\n", s, num_args);

    s->specific_data = NULL;
    le_session_create(s);
    return (LE_OK);
}

Bool if_le_DestroySC(iml_session_t * s)
{
    DEBUG_printf("if_le_DestroySC(), s: %p\n", s);

    le_session_destroy(s);
    return (LE_OK);
}

Bool if_le_GetSCValue(iml_session_t * s, IMArgList args, int num_args)
{
    DEBUG_printf("if_le_GetSCValue(), s: %p\n", s);
    return (LE_OK);
}

Bool if_le_SetSCValue(iml_session_t * s, IMArgList args, int num_args)
{
    int i;
    IMArg *p = args;

    DEBUG_printf("if_le_SetSCValue(), s: %p\n", s);

    le_session_set_as_desktop_current_session(s);

    for (i = 0; i < num_args; i++, p++) {
	switch (p->id) {
	case SC_TRIGGER_ON_NOTIFY:
	    DEBUG_printf("  SC_TRIGGER_ON_NOTIFY\n");
	    le_session_set_conversion_status(s, CONVERSION_ON);
	    break;
	case SC_TRIGGER_OFF_NOTIFY:
	    DEBUG_printf("  SC_TRIGGER_OFF_NOTIFY\n");
	    le_session_set_conversion_status(s, CONVERSION_OFF);
	    break;
	case SC_REALIZE:
	    DEBUG_printf("  SC_REALIZE\n");
	    break;
	case SC_CLIENT_LOCALE:
	    DEBUG_printf("  SC_CLIENT_LOCALE: [%s]\n", p->value);
	    break;
	default:
	    break;
	}
    }
    return (LE_OK);
}

IMText *if_le_ResetSC(iml_session_t * s)
{
    DEBUG_printf("if_le_ResetSC(), s: %p\n", s);

    IMText *im_text = (IMText *) le_session_reset(s);
    return (IMText *) im_text;
}

void if_le_SetSCFocus(iml_session_t * s)
{
    DEBUG_printf("if_le_SetSCFocus(), s: %p\n", s);

    le_session_set_focus_in(s);
    return;
}

void if_le_UnsetSCFocus(iml_session_t * s)
{
    DEBUG_printf("if_le_UnsetSCFocus(), s: %p\n", s);

    le_session_set_focus_out(s);
    return;
}

void if_le_SendEvent(iml_session_t * s, IMInputEvent * ev)
{
    DEBUG_printf("if_le_SendEvent(), desktop: %p, session: %p\n", s->desktop, s);

    if (ev) {
	if (ev->type == IM_EventKeyList) {
	    DEBUG_printf("Keyboard Event\n");
	    le_session_process_key_event(s, (IMKeyListEvent *) ev);
#if 0
	} else if (ev->type == IM_EventAux) {
	    DEBUG_printf("Aux Event\n");
	    le_session_process_aux_event(s, (IMAuxEvent *) ev);
#endif
	}
    }
}
