/* 
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef SUNIMPRIV_H
#define SUNIMPRIV_H

#ifndef BUFSIZE
#undef BUFSIZE
#define BUFSIZE 256
#endif /* BUFSIZE */
#define SLOTMINSIZE 64
#define Private static

typedef struct {
    IMText *text;
} status_cache_t ;

/*
 * several buffer size definitions
 */
#define DEFAULTPreEditTextBufferSize 512
#define DEFAULTPreEditAttrBufferSize 512
#define DEFAULTStatusCacheSize 512
#define DEFAULTXLookupStringBufferSize 512
#define LOCALENAMELEN 64
#define DEFAULTFeedbackSize	5

/*
 * for the active_regions (just for double check)
 */
#define PREEDIT_IS_ACTIVE	0x00000001
#define STATUS_IS_ACTIVE	0x00000002
#define LOOKUP_IS_ACTIVE	0x00000004
#define AUX_IS_ACTIVE		0x00000008

/*
 * for the current_active_regions
 */
#define PREEDIT PREEDIT_IS_ACTIVE
#define STATUS  STATUS_IS_ACTIVE	
#define LOOKUP  LOOKUP_IS_ACTIVE
#define AUX     AUX_IS_ACTIVE

#define IS_REGION_ACTIVE(s, x)   (s->current_active_region & (x))
#define ACTIVATE_REGION(s, x)    (s->current_active_region |= (x))
#define INACTIVATE_REGION(s, x) (s->current_active_region &= ~(x))

#endif  /* SUNIMPRIV_H */
