#include <stdio.h>

#include "le_info.h"
#include "le_object.h"

extern char lename_string[];
extern UTFCHAR lename_utf_string[];

static IMLEName lename = { lename_string, lename_utf_string };

#define  LE_VERSION    "2.0"

extern LeInfoRec *le_info;
extern UTFCHAR *le_locale_name[];

IMLocale locales[MAX_SUPPORT_LOCALES];

LeObjectRec *le_object_new()
{
    LeObjectRec *le_object = NULL;
    IMObjectDescriptorStruct *im_objects, *l;

    int i, j, num_input_methods;
    int num_locales;

    if (le_info == NULL || le_info->num_input_methods <= 0)
        return NULL;

    le_object = (LeObjectRec *) calloc(1, sizeof(LeObjectRec));
    if (le_object == NULL)
        return NULL;

    /* initilize the IMObjectDescriptorStruct */
    im_objects = (IMObjectDescriptorStruct *) calloc(2, sizeof(IMObjectDescriptorStruct));
    if (im_objects == NULL) {
        free ((char *)locales);
	free ((char *)le_object);
	return NULL;
    }

    l = im_objects;
    l->leid = lename_string;	/* engine id */
    l->type = IM_DOWNLOADINGOBJECT_BINGUI_TYPE;	/* object type */
    l->name = lename_utf_string;
    l->name_length = UTFCHARLen(lename_utf_string);
    l->domain = "com.sun";
    l->scope = lename_string;

    l->path = NULL;
    l->signature = "";
    l->basepath = NULL;		/* only for CCDEF */
    l->encoding = NULL;		/* only for CCDEF */

    /* initilize the le_object info */
    le_object->version = LE_VERSION;

    le_object->lename = (IMLEName *) &lename;

    memset(locales, 0, MAX_SUPPORT_LOCALES * sizeof (IMLocale));

    num_locales = 0;
    for (i = 0; i < le_info->num_input_methods; i ++) {
        MSymbol m_lang = le_info->input_methods[i]->language;
        char *lang = msymbol_name(m_lang);
        char *standard_lang_name;
        int find = 0;

        if (m_lang == Mt)
            continue;

        if (le_info_check_language_disabled(le_info, lang))
            continue;

        standard_lang_name = (char *)le_info_get_standard_language_name(lang);
        if (!standard_lang_name || !*standard_lang_name)
            continue;

        for (j = 0; j < num_locales; j++) {
            if (!strcasecmp(locales[j].id, standard_lang_name)) {
                find = 1;
                break;
            }
        }

        if (find == 0) {
            locales[num_locales].id = (char *)strdup(standard_lang_name);
            locales[num_locales].name = (UTFCHAR *)calloc(strlen(standard_lang_name)+1,sizeof(UTFCHAR));
	    for (j = 0; j < strlen(standard_lang_name); j++)
                locales[num_locales].name[j] = standard_lang_name[j];
            num_locales ++;
            if (num_locales >= MAX_SUPPORT_LOCALES - 1)
                break;
        }
    }
    locales[num_locales].id = NULL;
    locales[num_locales].name = NULL;

    le_object->locales = (IMLocale **) &locales;

    le_object->objects = im_objects;

    return le_object;
}

void le_object_destroy(LeObjectRec *le_object)
{
    int i;
    IMObjectDescriptorStruct *im_objects;

    if (le_object != NULL) {
        im_objects = le_object->objects;
        if (im_objects != NULL)
            free((char *) im_objects);

        free((char *) le_object);
    }

    for (i = 0; i < MAX_SUPPORT_LOCALES; i++) {
        if (locales[i].id)
            free ((char *)locales[i].id);
        if (locales[i].name)
            free ((char *)locales[i].name);
    }

    return;
}
