/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef LE_XML_CONF_H
#define LE_XML_CONF_H

#include "SunIM.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _IIIMLEXMLConf		IIIMLEXMLConf;
typedef struct _IIIMLEXMLConfPrivate	IIIMLEXMLConfPrivate;
typedef struct _IIIMLEInfoList		IIIMLEInfoList;
typedef struct _IIIMLEInfo		IIIMLEInfo;
typedef struct _IIIMLELanguageList	IIIMLELanguageList;
typedef struct _HotKeyStruct		HotKeyStruct;
typedef struct _HotKeyList              HotKeyList;

struct _IIIMLEXMLConf {
	char                 *filename;
	IIIMLEXMLConfPrivate *priv;
};
struct _IIIMLEInfoList {
	IIIMLEInfo     *data;
	IIIMLEInfoList *next;
};
struct _IIIMLEInfo {
	char       *language;
	char       *lename;
};
struct _IIIMLELanguageList {
	char *language;
	struct _IIIMLELanguageList *next;
};
struct _HotKeyStruct {
	char *modifiers;
	char *key;
	int keycode;
	int modmask;
};
struct _HotKeyList {
	HotKeyStruct *hotkey;
	HotKeyList   *next;
};


void            iiim_log_init                   (const char    *name);
void            iiim_log_debug_mode             (void);

IIIMLEXMLConf  *iiim_le_xmlconf_new             (const char    *filename);
void            iiim_le_xmlconf_free            (IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_load_file       (IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_load_with_nsio  (IIIMLEXMLConf *conf,
						 iml_desktop_t *iml_desktop);
int             iiim_le_xmlconf_save_file       (IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_is_empty_module (IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_append_module   (IIIMLEXMLConf *conf,
						 const char    *modulename,
						 const char    *language);
int             iiim_le_xmlconf_prepend_module  (IIIMLEXMLConf *conf,
						 const char    *modulename,
						 const char    *language);
int             iiim_le_xmlconf_remove_module   (IIIMLEXMLConf *conf,
						 const char    *modulename,
						 const char    *language);
IIIMLEInfoList *iiim_le_xmlconf_get_le_info_list(IIIMLEXMLConf *conf,
						 const char    *language);
IIIMLELanguageList *iiim_le_xmlconf_get_lang_list(IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_is_empty_hotkey (IIIMLEXMLConf *conf);
int             iiim_le_xmlconf_append_hotkey   (IIIMLEXMLConf *conf,
						 HotKeyStruct  *hotkey,
						 const char    *language);
int             iiim_le_xmlconf_remove_hotkey   (IIIMLEXMLConf *conf,
						 HotKeyStruct  *hotkey,
						 const char    *language);
int             iiim_le_xmlconf_clear_hotkey    (IIIMLEXMLConf *conf,
						 const char    *language);
HotKeyList     *iiim_le_xmlconf_get_hotkey_list (IIIMLEXMLConf *conf,
						 const char    *language);
HotKeyStruct   *iiim_le_hotkey_struct_new       (const char    *name,
						 const char    *modifiers);
void            iiim_le_hotkey_struct_free      (HotKeyStruct  *hotkey);
HotKeyList     *iiim_le_hotkey_list_new         (HotKeyStruct  *hotkey);
HotKeyList     *iiim_le_hotkey_list_add         (HotKeyList    *list,
						 HotKeyStruct  *hotkey);
HotKeyList     *iiim_le_hotkey_list_remove      (HotKeyList    *list,
						 HotKeyStruct  *hotkey);
HotKeyList     *iiim_le_hotkey_list_find        (HotKeyList    *list,
						 HotKeyStruct  *hotkey);
void            iiim_le_hotkey_list_free        (HotKeyList    *list);

#ifdef __cplusplus
}
#endif

#endif /* LE_XML_CONF_H */
