#ifndef IIIMP_HOTKEY_HH_
#define IIIMP_HOTKEY_HH_
#include <iiimp.h>
#include "basictype.hh"
#include "IIIMP_ICState.hh"

#define EVENT_FORWARDING_ON 1
#define EVENT_FORWARDING_OFF 0

#define HOTKEY_ID_LANG_SWITCH 1
#define HOTKEY_ID_SUPER_HELP 2

class LangIM
{
    int index;
    const char *lang_id;
    u16string imname;
    u16string hrn;

  public:
    int get_index() const
    { return index; }
    const char* get_id() const
    { return lang_id; }
    const u16string& get_imname() const
    { return imname; } 
    const u16string& get_hrn() const
    { return hrn; } 

    LangIM(
	int x_index,
	const char *x_langid,
	u16string x_imname,
	u16string x_hrn
    ) : index(x_index), lang_id(x_langid), imname(x_imname), hrn(x_hrn)
    {}
};
typedef list<LangIM> LangIMList;

class IIIMP_ICState;

class IIIMP_hotkey 
{
    bool hotkey_mode;
    bool lang_selection;
    int first_candidate;
    int last_candidate;
    int current;
    int curr_hotkeyid;

  public:
    IIIMP_hotkey(
	IIIMP_ICState *hics
    );
    ~IIIMP_hotkey();
    bool process_hotkey(
        IIIMP_ICState *hics,
        int hotkey_id,
        int index
    );
    void set_hotkey_mode(bool flag) { hotkey_mode = flag; }
    bool get_hotkey_mode() const { return hotkey_mode; }
    void set_lang_selection(bool flag) { lang_selection = flag; }
    bool get_lang_selection() const { return lang_selection; }
    bool
    send_hotkey_reply(IIIMP_ICState *hics);
    int
    UTFCHARLen(UTFCHAR *);
    int
    UTFCHARLen(const char *);
    int
    UTFCHARCpy(UTFCHAR *, const char *);
    int
    UTFCHARCpy(UTFCHAR *, UTFCHAR *);
    int
    UTFCHARCat(UTFCHAR *, const char *, const char *, const char *, const char *);
    IMFeedbackList *
    create_feedback(int);
    void
    free_feedback(IMFeedbackList *, int);
    bool
    switch_language(IIIMP_ICState *hics, int index, int hotkey_id);
    bool
    start_lang_selection_window(IIIMP_ICState *hics);
    void print_LangIMList(IIIMP_ICState *hics);
    bool
    process_lang_selection_window(
	IIIMP_ICState *hics,
	IIIMP_message *pmes
    );
    bool
    draw_lang_selection_window(
	IIIMP_ICState *hics,
	int keycode
    );
    bool
    stop_lang_selection_window(IIIMP_ICState *hics);
};

#endif /* not IIIMP_HOTKEY_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
