#ifndef IIIMPTRANS_HH_
#define IIIMPTRANS_HH_
#include <string>
#include <iiimp.h>
#include "basictype.hh"
#include "IMUtil.hh"

extern "C" IIIMF_status IIIMPTrans_read(
    IIIMF_stream_private ptrans,
    void *buf,
    size_t nbyte
);
extern "C" IIIMF_status IIIMPTrans_write(
    IIIMF_stream_private ptrans,
    const void* buf,
    size_t nbyte
);
class IIIMPTrans {
    bool open;
    IMSocketTrans *pimst;
    IIIMP_data_s *pimplibstate;
    IIIMF_stream *pstream;

  private:
    // inhibit duplication.
    IIIMPTrans(const IIIMPTrans&);
    IIIMPTrans& operator=(const IIIMPTrans& a);

  public:
    IIIMPTrans(IMSocketTrans *pimst);
    ~IIIMPTrans();
    bool send(IIIMP_message *pmes);
    IIIMP_message* receive();

    bool open_p()
    { return open; }

    IIIMP_data_s* get_data_s()
    { return pimplibstate; }
    int get_fd() const
    { return pimst->get_fd(); }

  friend IIIMF_status IIIMPTrans_read(IIIMF_stream_private, void*, size_t);
  friend IIIMF_status IIIMPTrans_write(IIIMF_stream_private, const void*, size_t);
};

#endif /* not IIIMPTRANS_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
