/* $Id: im-misc.c,v 1.1.1.1 2002/08/31 04:18:06 himi Exp $ */


#include <iiimp-data.h>

#include "iiimp-dataP.h"


IIIMP_status
iiimp_simple_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id)
{
    *ptr_ret = iiimp_simple_new(data_s, opcode, im_id, ic_id);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_connect_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_string *	user_name,
    IIIMP_string *	auth)
{
    *ptr_ret = iiimp_connect_new(data_s, user_name, auth);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_connect_reply_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_string *	language_list)
{
    *ptr_ret = iiimp_connect_reply_new(data_s, im_id, language_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_register_trigger_keys_create(
    IIIMP_data_s *		data_s,
    IIIMP_message **		ptr_ret,
    IIIMP_card16		im_id,
    IIIMP_keyevent_list *	trigger_on,
    IIIMP_keyevent_list *	trigger_off)
{
    *ptr_ret = iiimp_register_trigger_keys_new(data_s, im_id,
					       trigger_on, trigger_off);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_trigger_notify_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	flag)
{
    *ptr_ret = iiimp_trigger_notify_new(data_s, im_id, ic_id, flag);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_setimvalues_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_imattribute *	attr_list)
{
    *ptr_ret = iiimp_setimvalues_new(data_s, im_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_getimvalues_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16_list *	attr_list)
{
    *ptr_ret = iiimp_getimvalues_new(data_s, im_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_getimvalues_reply_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_imattribute *	attr_list)
{
    *ptr_ret = iiimp_getimvalues_reply_new(data_s, im_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_forward_event_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	contents)
{
    *ptr_ret = iiimp_forward_event_new(data_s, im_id, ic_id, contents);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_commit_string_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	contents)
{
    *ptr_ret = iiimp_commit_string_new(data_s, im_id, ic_id, contents);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_forward_event_with_operations_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	contents,
    IIIMP_operation *	operation)
{
    *ptr_ret = iiimp_forward_event_with_operations_new(data_s, im_id, ic_id,
						       contents, operation);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_forward_event_with_operations_reply_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_operation *	operation)
{
    *ptr_ret = iiimp_forward_event_with_operations_reply_new(data_s,
							     im_id, ic_id,
							     operation);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_createic_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_icattribute *	attr_list)
{
    *ptr_ret = iiimp_createic_new(data_s, im_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_seticvalues_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_icattribute *	attr_list)
{
    *ptr_ret = iiimp_seticvalues_new(data_s, im_id, ic_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_geticvalues_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16_list *	attr_list)
{
    *ptr_ret = iiimp_geticvalues_new(data_s, im_id, ic_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_geticvalues_reply_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_icattribute *	attr_list)
{
    *ptr_ret = iiimp_geticvalues_reply_new(data_s, im_id, ic_id, attr_list);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_preedit_start_reply_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		maximum_length)
{
    *ptr_ret = iiimp_preedit_start_reply_new(data_s, im_id, ic_id,
					     maximum_length);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_preedit_draw_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		caret,
    IIIMP_int32		change_first,
    IIIMP_int32		change_length,
    IIIMP_contents *	preedit)
{
    *ptr_ret = iiimp_preedit_draw_new(data_s, im_id, ic_id, caret,
				      change_first, change_length, preedit);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_status_draw_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	status)
{
    *ptr_ret = iiimp_status_draw_new(data_s, im_id, ic_id, status);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_lookup_choice_start_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			master,
    int			choice_per_window,
    int			rows,
    int			columns,
    int			direction,
    int			label_owner)
{
    *ptr_ret = iiimp_lookup_choice_start_new(data_s, im_id, ic_id,
					     master, choice_per_window,
					     rows, columns, direction,
					     label_owner);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_lookup_choice_draw_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    int			first,
    int			last,
    int			current,
    IIIMP_text *	choice,
    IIIMP_text *	index_label,
    IIIMP_text *	title)
{
    *ptr_ret = iiimp_lookup_choice_draw_new(data_s, im_id, ic_id,
					    first, last, current,
					    choice, index_label, title);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_lookup_choice_process_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	type,
    IIIMP_card16	value)
{
    *ptr_ret = iiimp_lookup_choice_process_new(data_s, im_id, ic_id,
					       type, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_aux_simple_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name)
{
    *ptr_ret = iiimp_aux_simple_new(data_s, opcode, im_id, ic_id,
				    class_index, input_method_name);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_aux_value_create(
    IIIMP_data_s *	data_s,
    IIIMP_message **	ptr_ret,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name,
    IIIMP_card32_list *	integer_value,
    IIIMP_string *	string_value)
{
    *ptr_ret = iiimp_aux_value_new(data_s, opcode, im_id, ic_id,
				   class_index, input_method_name,
				   integer_value, string_value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
